<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFiberPortsOdfTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fiber_ports_odf', function (Blueprint $table) {
            $table->id();

            $table->foreignId("odf_id");
            $table->string("type")->default("fiber_port");

            $table->string("label")->nullable();
            $table->integer("row");
            $table->integer("column");

            $table->foreignId("front_panel_component_id")->nullable();
            $table->string("front_panel_component_type")->nullable();

            $table->foreignId("back_panel_component_id")->nullable();
            $table->string("back_panel_component_type")->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fiber_ports_odf');
    }
}
