<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Database\Seeders\UserHasRole;
use Illuminate\Support\Facades\DB;
use App\Models\Settings;

class SettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $setting = Settings::get();
        //dd($setting);

        return view('Settings.index',[
            'settings' => $setting,
            'page_title' => 'Company details'
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Settings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       //dd($request);
       $this->validate(
        $request,
        [
            'company_name' => 'required',
            'logo' => 'required'
         
        ],
    );

         $company_name = $request->company_name;
         $image = $request->file('logo');
         $imageName = time().'.'.$image->extension();
         $image->move(public_path('storage'),$imageName);

         $setting = new Settings();

         $setting->company_name = $company_name;
         $setting->logo = $imageName;
         $setting->company_email = $request->company_email;
         $setting->company_location = $request->company_location;
         $setting->company_contact = $request->company_contact;
         $setting->save();

         return redirect()->back();


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Settings $settings)
    {
        $settings = Settings::find($settings->id);
        return view('Settings.update', [
            'settings' => $settings,
            'page_title' => 'Update Companys Information'
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
