<?php

namespace App\Jobs;

use App\Classes\MikrotikService\SyncWithMk;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class PopEnableJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $popId;
    public function __construct($popId)
    {
        $this->popId = $popId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if (checkAPI()) {
            (new SyncWithMk)->syncSinglePop($this->popId);
        }
    }
}
