@extends('layout.app')
@section('content')

    <div class="card">
        <div class="card-body">
            <div class="table-responsive" style="min-height:500px;">
                <table id="dataTable" class="table" >
                    <thead class="bg-gray-50">
                        <tr>
                            <th>ID</th>
                            <th>User's name</th>
                            <th>Email</th>
                            <th>Company</th>
                            <th>Role</th>
                            <th>Active State</th>
                            <th>Accounting</th>
                            <th>Last Edit By</th>
                            <th> </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $r)
                            {{-- hide user of support and soiket --}}
                            @if ($r->email =="support@yetfix.com" || $r->email =="soiket@outlook.com")

                            @else
                            <tr>
                                <td>{{ $r->id }}</td>
                                <td>{{ $r->name }}</td>

                                <td>{{ $r->email }}</td>

                                <td>{{ $r->userdetails->company ?? '' }}</td>

                                <td>
                                    @foreach ($r->role as $role)
                                        <span class="btn btn-info btn-xs">{{ $role->name }}</span>
                                    @endforeach
                                </td>

                                <td class="text-center">
                                    <x-Custom.Status status="{{ $r->userdetails->user_status ?? '' }}" />
                                </td>

                                <td class="text-center">
                                    {{$r->user_accounting_status}}
                                </td>

                                <td>
                                    @if (isset($r->userdetails->last_edit_by) &&  $r->userdetails->last_edit_by!= 1)

                                            {{$all_user[$r->userdetails->last_edit_by] ?? ''}}
                                    @endif

                                    {{-- {{$r->userdetails->last_edit_by}} --}}

                                </td>

                                <td class="px-6 text-left text-sm font-medium" style="max-width:300px">

                                    <div class="dropdown">
                                        <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            @can('user_edit')
                                            <a class="dropdown-item" href="{{ route('user.edit', $r->id) }}">Edit</a>
                                            @endcan
                                            @can('admin-password-reset')
                                                <a class="dropdown-item" href="{{ route('passwordReset', $r->email) }}">Reset
                                                    Password</a>
                                            @endcan
                                            @can('assign-user-pop')
                                                <a class="dropdown-item" href="{{ route('assignPop', $r->id) }}">Assign
                                                    POP</a>
                                            @endcan
                                            @can('assign-role')
                                                <a class="dropdown-item" href="{{ route('userRole', $r->email) }}">Assign
                                                    Role</a>
                                            @endcan
                                            @can('assign-user-reseller')
                                                <a class="dropdown-item" href="{{ route('assignReseller', $r->id) }}">Assign
                                                    Reseller</a>
                                            @endcan
                                            @unlessrole('Reseller Admin|Reseller|Sub Reseller')
                                                <a class="dropdown-item"
                                                    href="{{ route('view_user_account_history', $r->id) }}">Account
                                                    History</a>
                                            @endunlessrole
                                            @can('user-balance-recharge')
                                            @if($r->user_balance_check == 'yes')

                                                <a class="dropdown-item" href="{{ route('user-recharge', $r->id) }}">Balance Recharge</a>

                                            @endif

                                            @endif
                                            <a class="dropdown-item" href="{{ route('userLogInfo',$r->id) }}">User
                                                LogInfo</a>

                                            <a href="{{ route('editLog-history', ['id' => $r->id, 'type' => 'AdminUser']) }}"
                                                class="dropdown-item">Update History</a>
                                            <a href="{{ route('editLog-history', ['id' => $r->id, 'type' => 'UserRole']) }}"
                                                class="dropdown-item">Role History</a>
                                            <a href="{{ route('userCustomerSummary', $r->id) }}"
                                                class="dropdown-item">Customer Summary</a>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endif

                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>
    </div>




@endsection
