import { useState } from 'react';
import { Button, Form } from 'react-bootstrap';
import { Modal } from 'react-bootstrap';
import { useDispatch } from 'react-redux';
import { updateOnuInCluster } from '../../../../../../store/asyncMethods/onuMethod';

export function UpdateOnuDetail({ onuDetail, setOnuDetail }) {
    const dispatch = useDispatch();
    const oldData = {
        name: onuDetail.name,
        serial_number: onuDetail.serial_number,
        manufactures: onuDetail.manufactures,
        model: onuDetail.model,
        remarks: onuDetail.remarks,
        mac_address: onuDetail.mac_address,
    };
    const [newData, setNewData] = useState(oldData);

    const [show, setShow] = useState(false);

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);

    const onSubmitHandler = (e) => {
        e.preventDefault();
        dispatch(
            updateOnuInCluster(onuDetail.id, newData, (updatedData) => {
                setOnuDetail((prevState) => {
                    return {
                        ...prevState,
                        name: updatedData.name,
                        serial_number: updatedData.serial_number,
                        manufactures: updatedData.manufactures,
                        model: updatedData.model,
                        remarks: updatedData.remarks,
                        mac_address: updatedData.mac_address,
                    };
                });
                setShow(false);
            })
        );
    };

    const onChangeHandler = (e) => {
        setNewData({ ...newData, [e.target.name]: e.target.value });
    };

    return (
        <>
            <Button variant='warning' onClick={handleShow}>
                Update
            </Button>
            <Modal show={show} onHide={handleClose}>
                <Modal.Header closeButton>
                    <Modal.Title>Update Splitter Info</Modal.Title>
                </Modal.Header>
                <Form onSubmit={onSubmitHandler}>
                    <Modal.Body>
                        <Form.Group className='mb-2'>
                            <Form.Label>Name</Form.Label>
                            <Form.Control
                                type='text'
                                placeholder='Enter name'
                                name='name'
                                value={newData.name}
                                onChange={onChangeHandler}
                            />
                        </Form.Group>
                        <Form.Group className='mb-2'>
                            <Form.Label>Serial Number</Form.Label>
                            <Form.Control
                                type='text'
                                placeholder='Enter serial number'
                                name='serial_number'
                                value={newData.serial_number}
                                onChange={onChangeHandler}
                            />
                        </Form.Group>
                        <Form.Group className='mb-2'>
                            <Form.Label>Manufactures</Form.Label>
                            <Form.Control
                                type='text'
                                placeholder='Enter manufactures'
                                name='manufactures'
                                value={newData.manufactures}
                                onChange={onChangeHandler}
                            />
                        </Form.Group>
                        <Form.Group className='mb-2'>
                            <Form.Label>Model</Form.Label>
                            <Form.Control
                                type='text'
                                placeholder='Enter model'
                                name='model'
                                value={newData.model}
                                onChange={onChangeHandler}
                            />
                        </Form.Group>
                        <Form.Group className='mb-2'>
                            <Form.Label>Remarks</Form.Label>
                            <Form.Control
                                type='text'
                                placeholder='Enter remarks'
                                name='remarks'
                                value={newData.remarks}
                                onChange={onChangeHandler}
                            />
                        </Form.Group>
                        <Form.Group className='mb-2'>
                            <Form.Label>Mac Address</Form.Label>
                            <Form.Control
                                type='text'
                                placeholder='Enter mac address'
                                name='mac_address'
                                value={newData.mac_address}
                                onChange={onChangeHandler}
                            />
                        </Form.Group>
                    </Modal.Body>
                    <Modal.Footer>
                        <Button variant='secondary' onClick={handleClose}>
                            Close
                        </Button>
                        <Button variant='primary' type='submit'>
                            Save Changes
                        </Button>
                    </Modal.Footer>
                </Form>
            </Modal>
        </>
    );
}
