@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">
                <i class="fas fa-phone mr-2"></i>
                Voice Call Log
            </h3>
        </div>
        <div class="card-body">
            <form action="{{ route('voice-log.index') }}" method="GET" id="search">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">From Date</label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ request('from_date') }}"
                                    class="form-control form-control-sm datetimepicker-input"
                                    data-toggle="datetimepicker" data-target="#searchFrom" placeholder="From Date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">To Date</label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ request('to_date') }}"
                                    class="form-control form-control-sm datetimepicker-input"
                                    data-toggle="datetimepicker" data-target="#searchTo" placeholder="To Date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Type</label>
                            <select name="type" class="form-control form-control-sm">
                                <option value="">All Type</option>
                                @foreach ($types as $type)
                                    <option value="{{ $type }}" {{ request('type') == $type ? 'selected' : '' }}>{{ $type }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Contact No</label>
                            <input type="text" name="contact" value="{{ request('contact') }}"
                                class="form-control form-control-sm" placeholder="Phone No" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group float-right mt-4">
                            <button type="submit" class="btn btn-primary btn-sm">
                                <i class="fa fa-search"></i> Search
                            </button>
                            <a href="{{ route('voice-log.index') }}" class="btn btn-info btn-sm">Reset</a>
                        </div>
                    </div>
                </div>
            </form>

            <div class="table-responsive">
                <table id="dataTable" class="display table table-bordered table-striped table-sm">
                    <thead class="bg-gray">
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Contact</th>
                            <th scope="col">Caller ID</th>
                            <th scope="col">Type</th>
                            <th scope="col">Call Status</th>
                            <th scope="col">Date</th>
                            <th scope="col">Blast ID</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($voiceLogs as $item)
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->contact }}</td>
                                <td>{{ $item->callerid }}</td>
                                <td>{{ $item->type }}</td>
                                <td>
                                    @if($item->call_status == 'Success')
                                        <span class="badge badge-success">Success</span>
                                    @else
                                        <span class="badge badge-danger">{{ $item->call_status ?? 'N/A' }}</span>
                                    @endif
                                </td>
                                <td>{{ $item->created_at->format('Y-m-d H:i:s') }}</td>
                                <td>{{ $item->blast_id }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $voiceLogs->links() }}
            </div>
        </div>
        <div class="card-footer">
        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();

            // Initialize datetime pickers
            $('#searchFrom').datetimepicker({
                format: 'YYYY-MM-DD',
                icons: {
                    time: 'far fa-clock',
                    date: 'far fa-calendar',
                    up: 'fas fa-arrow-up',
                    down: 'fas fa-arrow-down'
                }
            });

            $('#searchTo').datetimepicker({
                format: 'YYYY-MM-DD',
                icons: {
                    time: 'far fa-clock',
                    date: 'far fa-calendar',
                    up: 'fas fa-arrow-up',
                    down: 'fas fa-arrow-down'
                }
            });
        });
    </script>
@endsection

