<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BandPurchase extends Model
{
    use HasFactory;
    // protected $guarded=['id'];

    protected $fillable = [
        'bill_no',
        'invoice_no',
        'provider_id',
        'billing_date',
        'total_qty',
        'subTotal',
        'marketing_total',
        'total',
    ];

    public function provider()
    {
        return $this->belongsTo(BandProvider::class, 'provider_id', 'id');
    }

    public function purchaseItem()
    {
        return $this->hasMany(BandPurchaseItem::class, 'bandPurchaseId', 'id');
    }
}
