<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrmItemReturn extends Model
{
    use HasFactory;

    public function crmItem()
    {
        return $this->belongsTo(CrmItem::class, 'crm_item_id');
    }
    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id')->withTrashed();
    }
    public function addedBy()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approve_by');
    }

    public function item()
    {
        return $this->belongsTo(Item::class, 'crm_item_id');
    }

}
