<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SchedulePackageChange extends Model
{
    use HasFactory;

    public function client()
    {
        return $this->belongsTo(Client::class,'client_id','id');
    }

    public function newSubPackage()
    {
        return $this->belongsTo(SubPackage::class,'new_sub_package_id','id');
    }

    public function newPackage()
    {
        return $this->belongsTo(Packages::class,'new_package_id','id');
    }

    public function scheduleBy()
    {
        return $this->belongsTo(User::class,'schedule_by','id');
    }
}
