@extends('layout.app')


@section('content')
    <!-- Main content -->
    <section class="content" id="app">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Horizontal Form -->
                    <div class="card card-primary">
                        <div class="card-header bg-light">
                            <div class="card-tools">
                                
                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                    data-target="#modal-fund-transfer">
                                    New Fund Transfer
                                </button>
                            </div>
                        </div>
                        {{-- {{$fund}} --}}
                        <form action="{{ route('fund-transfer.update',$fund->id) }}" method="post">
                            @csrf
                            @method('put')
                            <div class="">
                                <div class="modal-header">
                                    <h4 class="text-center">Fund Transfer Modify</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="text-center" id="modalAlert"></div>
    
                                    <div class="row">                                      
    
                                        <div class="col-md-4">Fund Send By</div>
                                        <div class="col-md-8 mb-2">
                                            <select class="form-control select2" name="send_by" id="" disabled>
                                                <option value="">Select Send By</option>
                                                <option @if($fund->fund_send_by == 0) selected @endif  value="0">CASH</option>
                                                @foreach ($users as $s)
                                                    <option 
                                                    @if($fund->fund_send_by == $s->id) selected @endif  value="{{ $s->id }}">{{ $s->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
    
                                        <div class="col-md-4">Fund Received By</div>
                                        <div class="col-md-8 mb-2">
                                            <select class="form-control select2" name="received_by" id="" disabled>
                                                <option value="">Select Received By</option>
                                                <option @if($fund->fund_received_by == 0) selected @endif  value="0">CASH</option>
                                                @foreach ($users as $s)
                                                    <option @if($fund->fund_received_by == $s->id) selected @endif value="{{ $s->id }}">{{ $s->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
    
                                        <div class="col-md-4">Transfer Amount</div>
                                        <div class="col-md-8 mb-2">
                                            <input type="number" name="amount" class="form-control" value="{{ abs($fund->amount) }}">
                                        </div>
    
                                        <div class="col-md-4">Note</div>
                                        <div class="col-md-8 mb-2">
                                            <textarea name="note" id="note" class="form-control">{{$fund->note}}</textarea>
                                        </div>
    
    
                                    </div>
    
    
                                </div>
                                <div class="modal-footer justify-content-between">
                                    <a href="{{route('fund-transfer.index')}}" class="btn btn-default">Back</a>
                                    <button class="btn btn-primary" type="submit" id="modalSave">Update</button>
                                </div>
    
                            </div>
                            <!-- /.modal-content -->
                        </form>


                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-2"></div>
            </div>
            <!-- /.row -->

           

            

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@section('ajax')

@endsection
