@extends('layout.app')


@section('content')



<div class="flex flex-col mt-5">
  <div class=" bg-white p-6 rounded-lg">

    <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
      <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
        <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
          <table id="dataTable" class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
              <tr>
              <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  ID
                </th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                Requisition Approve Number
                </th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                Requisition Number
                </th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                Remark
                </th>
            
               
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  Create Date
                </th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  
                </th>
              </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
              @forelse ($requisition_approves as $r)
              <tr>
              <td class="text-center">
                  {{ $r->id}}
                </td>
                <td class="text-center">
                  {{$r->requisition_approve_number}}
                </td>
                <td class="text-center">
                  {{$r->requisition->requisition_number}}
                </td>
                <td class="text-center">
                  {{$r->remark}}
                </td>

                <td class="text-center">
                  {{ date('d-M-Y H:i:s A',strtotime($r->created_at)) }}
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">

                  <x-Custom.Btn url="{{ route('requisition-approves.show',$r->id) }}" class="bg-blue-600 text-white" value="Show"/>

                </td>
              </tr>
              @empty

              @endforelse
            </tbody>
          </table>

          <div class="p-5">
            {{ $requisition_approves->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
</div>




@endsection