<?php

namespace App\Library;

use Illuminate\Support\Facades\Http;

class UddoktaPay
{

    /**
     * Send payment request
     *
     * @param array $requestData
     * @return void
     */
    public static function init_payment($requestData)
    {

        $response = Http::withHeaders([
            'Content-Type'          => 'application/json',
            'RT-UDDOKTAPAY-API-KEY' => env("UDDOKTAPAY_API_KEY"),
        ])
            ->asJson()
            ->withBody(json_encode($requestData), "JSON")
            ->post(env("UDDOKTAPAY_PAYMENT_DOMAIN") . "/api/checkout");

        if ($response->successful()) {

            if($response->collect()['status'] == false) {
                return response()->json([
                    'status' => 'error',
                    'message' => $response->collect()['message']
                ]);
            }else{
                $res =  $response->collect()['payment_url'];
                return response()->json([
                    'payment_url' => $res,
                    'status'      => 'success'
                ]);
            }            
            
        } else {
            return response()->json([
                'status' => 'error',
                'message' => $response->body()
            ]);
        }
    }
}
