<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\ClientEditLog;
use Illuminate\Support\Facades\Auth;
use App\Models\ClientImportAmountReport;
use App\Http\Controllers\Api\ClientController;


class UpdateClientInfoService
{
    public function updateClientInfo($old_client, $data, $package, $subPackage, $pop, $int_billing_cycle, $expire, $joiningDate, $number, $division , $district, $upazila)
    {
        $old_client = Client::with('clientsinfo')->withTrashed()->find($old_client->id);
        $row = $data;


        $client = Client::with('clientsinfo')->withTrashed()->find($old_client->id);

        if (is_numeric($row[1]) && strlen($row[1]) == 10 && strlen($row[1]) < 11) {
            $client->password = '0' . trim($row[1]);
        } else {
            $client->password = trim($row[1]);
        }

        $client->package_id = $package->id;
        if (isset($subPackage)) {
            $client->sub_package_id = $subPackage->id;
        }else{
            $client->sub_package_id = null;
        }

        $client->pop_id = $pop->id;
        $client->billing_cycle = $int_billing_cycle;
        $client->expire_date = Carbon::parse($expire)->format('Y-m-d 00:00:00');
        $client->required_cable = 0;
        $client->created_by = auth()->user()->id;
        $client->client_approval = "pending";
        $client->clients_status = "deactive";
        if (trim($row[16]) != "") {
            $client->customer_code = trim($row[16]);
        }

        if($client->deleted_at != null){
            $client->deleted_at = null;
        }

        $client->save();

        $clientInfo = Clientsinfo::where('client_id', $client->id)->first();
        $clientInfo->clients_name = $row[2];
        $clientInfo->contact_no = $number;
        $clientInfo->email = $row[8] ?? "";
        $clientInfo->father_name = $row[9] ?? "";
        $clientInfo->mother_name = $row[10] ?? "";
        $clientInfo->area = $row[11] ?? "";
        $clientInfo->remarks = $row[12] ?? "";
        $clientInfo->joinDate = $joiningDate;
        $clientInfo->cable_type = $row[14] ?? "";
        $clientInfo->division = $division->id ?? "";
        $clientInfo->district = $district->id ?? "";
        $clientInfo->upazila = $upazila->id ?? "";

        $clientInfo->save();

        $new_data_client = Client::with('clientsinfo', 'packages')->withTrashed()->find($client->id);

        $this->clientEditLog($client, $old_client, $new_data_client);

        if (checkSettings('client_import_amount_report') == 'enable') {
            // Client Import Amount Report
            $clientImportAmountReport = new ClientImportAmountReport();
            $clientImportAmountReport->reseller_id = $pop->reseller_id;
            $clientImportAmountReport->pop_id = $pop->id;
            $clientImportAmountReport->client_id = $client->id;
            $clientImportAmountReport->package_id = $package->id;
            $clientImportAmountReport->package_name = $package->package_name;
            if (isset($subPackage)) {
                $clientImportAmountReport->sub_package_id = $subPackage->id;
                $clientImportAmountReport->sub_package_name = $subPackage->name;
            }

            $dt = Carbon::now();
            $total_days = Carbon::parse($dt)->diffInDays(Carbon::parse($expire)->format('Y-m-d 00:00:00')) + 1;

            if ($dt > Carbon::parse($expire)->format('Y-m-d 00:00:00')) {
                $total_days = 0;
            }

            if ($total_days > 0) {
                $clientImportAmountReport->total_days = $total_days;
                $due_amount = ($package->package_rate / 30) * $total_days;

                $clientImportAmountReport->due_amount = $due_amount ?? 0;

                if (isset($subPackage)) {
                    $sub_due_amount = ($subPackage->rate / 30) * $total_days;
                    $clientImportAmountReport->sub_due_amount = $sub_due_amount ?? 0;
                }
            } else {
                $clientImportAmountReport->total_days = 0;
                $clientImportAmountReport->due_amount = 0;
                if (isset($subPackage)) {
                    $clientImportAmountReport->sub_due_amount = 0;
                }
            }

            $clientImportAmountReport->package_amount = $package->package_rate;
            if (isset($subPackage)) {
                $clientImportAmountReport->sub_package_amount = $subPackage->rate;
            }
            $clientImportAmountReport->save();
        }
    }

    private function clientEditLog($client, $old_client, $new_data_client)
    {
        $client_update_log = new ClientEditLog();
        $client_update_log->client_id = $client->id;
        $client_update_log->user_id = Auth::user()->id;
        $client_update_log->old_data = json_encode($old_client);
        $client_update_log->new_data = json_encode($new_data_client);
        $client_update_log->save();
    }
}
