@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('global-settings.update', $globalSettings->id) }}" method="POST">
                @method('put')
                @csrf
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Global Settings Name*
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">
                            <input type="hidden" value="{{ $globalSettings->id }}">
                            <input type="text" name="name" id="name" value="{{ $globalSettings->name }}"
                                class="form-control" placeholder="Global Settings Name" autocomplete="off">
                        </div>
                        @error('name')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="status" class="block text-sm font-medium text-gray-700">
                            Status*
                        </label>
                        <select name="status" id="status" class="select2 form-control">
                            <option value="">Select Status</option>
                            <option value="enable" @if ($globalSettings->status == 'enable') {{ 'selected' }} @endif>Enable
                            </option>
                            <option value="disable" @if ($globalSettings->status == 'disable') {{ 'selected' }} @endif>disable
                            </option>
                        </select>
                        @error('status')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-10">
                    <a href="{{ route('global-settings.index') }}" class="btn-black "> <i
                            class="fa fa-arrow-left"></i> Back to Permission List</a>

                    <button type="submit" class="btn btn-primary float-right">
                        Save
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
