@extends('layout.app')

@section('content')

    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Select Manager</label>
                            <select name="reseller" id="reseller" class="select2 form-control">
                                <option value="">Select One</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select POP
                        </label>
                        <select name="pop" id="pop" class="form-control select2">
                            <option value="">Select One</option>
                        </select>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>

            </form>


        </div>
    </div>



    <div class="card">
        <div class="card-body" id="leftClientResult">

            <div class="mb-4">
                <span class="bg-success p-2" style="border-radius: 5px;">
                    @php
                        $total = $deactiveCount + $deleteCount;
                    @endphp
                    Total Client: {{ $total }}
                </span>
            </div>


            <table id="dataTable" class="table table-bordered">

                <thead>
                    <tr>
                        <th scope="col" class="no-wrap">
                            ID
                        </th>
                        <th scope="col" class="no-wrap">
                            User name
                        </th>
                        <th scope="col" class="no-wrap">
                            Status
                        </th>
                        <th scope="col" class="no-wrap">
                            Expire
                        </th>
                        <th scope="col" class="no-wrap">
                            Bill Info
                        </th>
                        <th scope="col" class="no-wrap">
                            Package
                        </th>
                        <th scope="col" class="no-wrap">
                            POP
                        </th>
                        <th>
                            Name
                        </th>
                        <th>
                            Contact
                        </th>
                        <th scope="col" style="width:350px">
                            User Info
                        </th>
                        <th>
                            Remarks
                        </th>
                        <th scope="col" class="noprin">
                        </th>
                    </tr>
                </thead>
                <tbody>



                    @foreach ($deactive as $r)
                        <tr @if ($r->clients_status == 'deactive') class="deactive" @endif>

                            <td class="text-center">
                                <a class="btn btn-info btn-block btn-xs text-nowrap"
                                    href="{{ route('getPaymentHistory', $r->id) }}">CID: {{ $r->id }}</a>
                                @if (checkAPI() == false)
                                    <a href="{{ route('getCustomerLogHistory', $r->userid) }}"
                                        class="noprint btn btn-primary btn-xs btn-block">Log</a>
                                @endif

                                <a href="{{ route('clients.show', $r->id) }}"
                                    class="noprint btn btn-primary btn-xs btn-block">Details</a>

                            </td>
                            <td class="no-wrap">
                                {{ $r->userid }}
                                <br>
                                {{-- {{ $r->password }} --}}


                            </td>

                            <td
                                class="
                                @if ($r->deleted_at != null || $r->clients_status == 'expired') deactive bg-danger
                                @elseif($r->clients_status == 'deactive')
                                    bg-secondary
                                    @elseif($r->clients_status == 'disable')
                                    bg-warning
                                @elseif($r->clients_status == 'active')
                                bg-success @endif
                                ">
                                <x-Custom.Status status="{{ $r->clients_status }}" />
                            </td>
                            <td class=" @if ($r->deleted_at != null || $r->clients_status == 'expired') deactive bg-danger
                                            @elseif($r->clients_status == 'deactive') bg-secondary
                                            @elseif($r->clients_status == 'disable') bg-warning
                                            @elseif($r->clients_status == 'active')  bg-success @endif "
                                style="min-width:140px;text-align:left">
                                BD: {{ date('d-M-Y', strtotime($r->expire_date)) }}<br>
                                PD:
                                {{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}
                            </td>


                            <td style="min-width:130px">
                                <p style="font-size:14px;">
                                    B Cycle: {{ $r->billing_cycle }} <br>
                                    @if (isset($r->pop->bill_generate) && $r->pop->bill_generate == 'yes')
                                        B Amount: @role('Sub Reseller')
                                            @if ($r->pop->subreseller == 'yes')
                                                {{ $r->subpack->rate ?? 0 }}
                                            @else
                                                {{ $r->packages->package_rate }}
                                            @endif
                                        @else
                                            {{ $r->packages->package_rate }}
                                        @endrole <br>
                                        OTC : {{ $r->clientsinfo->otc ?? 0 }} <br>
                                        @if (isset($r->clientsinfo->otc_due))
                                            @if ($r->clientsinfo->otc_due > 0)
                                                <span class="bg-danger pl-1 pr-1"> OTC Due:
                                                    {{ $r->clientsinfo->otc_due ?? 0 }}</span>
                                            @endif
                                        @endif
                                    @endif
                                </p>

                                @if ($r->pop->bill_generate == 'yes')
                                    <p class="text-danger">Due: {{ $r->customerAccount->dueAmount ?? 0 }}</p>
                                @endif
                            </td>


                            <td>

                                @can('show-sub-package')
                                    <span class="d-block mb-1 badge badge-info">{{ $r->subpack->name ?? '' }}</span>
                                @endcan

                                @can('show-mother-package')
                                    <span class="d-block badge badge-info">
                                        {{ $r->packages->package_name ?? '' }}</span>
                                @endcan




                            </td>

                            <td class="no-wrap">
                                {{ $r->pop->popname ?? '' }}
                            </td>

                            <td>

                                {{ $r->clientsinfo->clients_name ?? '' }}
                            </td>
                            <td>
                                {{ $r->clientsinfo->contact_no ?? '' }}
                            </td>



                            <td style="width:350px;">
                                <p style="font-size:14px;">
                                    @if ($r->clientsinfo->flat_no)
                                        Flat No: {{ $r->clientsinfo->flat_no ?? '' }},
                                    @endif
                                    @if ($r->clientsinfo->building_name)
                                        Building Name: {{ $r->clientsinfo->building_name ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->road_no)
                                        Road No: {{ $r->clientsinfo->road_no ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->block_sector)
                                        Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }},
                                    @endif
                                    @if ($r->clientsinfo->area)
                                        Area : {{ $r->clientsinfo->area ?? '' }}, <br>
                                    @endif
                                    @if ($r->clientsinfo->box)
                                        Box : {{ $r->clientsinfo->box ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->client_latitude)
                                        Latitude : {{ $r->clientsinfo->client_latitude ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->client_longitude)
                                        Longitude : {{ $r->clientsinfo->client_longitude ?? '' }}
                                    @endif
                                </p>
                            </td>

                            <td>
                                {{ $r->clientsinfo->remarks ?? '' }}
                            </td>


                            <td class="text-center noprint" style="width:160px;">

                                @if ($r->deleted_at != null)
                                    <div class="dropdown">
                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">


                                            <a href="{{ route('clients.show', $r->id) }}" class="dropdown-item">Details</a>


                                            <div class="mb-1"></div>

                                            @can('can-open')
                                                <a href="{{ route('open', $r->id) }}"
                                                    onclick="return confirm('Are you sure you want to Open the ID?');"
                                                    class="confirmDisable dropdown-item bg-danger">Restore Account</a>
                                            @endcan

                                        </div>
                                    </div>
                                @else
                                    <div class="dropdown">



                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">




                                            @can('add-otc')
                                                @if (isset($r->clientsinfo->otc_due))
                                                    @if ($r->clientsinfo->otc < 1)
                                                        <button type="button" class="dropdown-item addOtc"
                                                            data-toggle="modal" data-id="{{ $r->id }}"
                                                            data-target="#addOtc">
                                                            Add Otc
                                                        </button>
                                                    @endif
                                                @endif
                                            @endcan


                                            <a href="{{ route('clients.show', $r->id) }}"
                                                class="dropdown-item">Details</a>

                                            @can('mac-customer_edit')
                                                <a href="{{ route('clients.edit', $r->id) }}" class="dropdown-item">Edit</a>
                                            @endcan

                                            @can('changeBillCycle')
                                                <button type="button" class="dropdown-item clientBillCycleChange"
                                                    data-toggle="modal" data-id="{{ $r->id }}"
                                                    data-curdate={{ $r->billing_cycle }} data-target="#billCycleChange">
                                                    Bill Cycle Change
                                                </button>
                                            @endcan


                                            <div class="mb-1"></div>


                                            @if ($r->client_approval == 'pending')
                                                @can('new-customer-approve')
                                                    <form method="POST" action="{{ route('clinetApprove', $r->id) }}">
                                                        @method('post')
                                                        @csrf
                                                        <input type="hidden" name="user_approve"
                                                            value="{{ $r->id }}">
                                                        <button
                                                            onclick="return confirm('Are you sure you want to Approved this user ?');"
                                                            type="submit" class="dropdown-item">Approve</button>
                                                    </form>
                                                @endcan
                                            @endif

                                            @if ($r->clients_status == 'disable')
                                                @can('id-enable')
                                                    <a href="{{ route('idEnable', $r->id) }}"
                                                        onclick="return confirm('Are you sure you want to Enable the ID?');"
                                                        class="dropdown-item">Enable</a>
                                                @endcan
                                            @endif

                                            @if ($r->clients_status == 'active')
                                                @can('id-disable')
                                                    <a href="{{ route('idDisable', $r->id) }}"
                                                        onclick="return confirm('Are you sure you want to Disable the ID?');"
                                                        class="confirmDisable dropdown-item">Disable</a>
                                                @endcan
                                            @endif

                                            @can('can-close')
                                                <a href="{{ route('close', $r->id) }}"
                                                    onclick="return confirm('Are you sure you want to Close the ID?');"
                                                    class="confirmDisable dropdown-item">Close</a>
                                            @endcan

                                            {{-- @can('mac_customer_destroy') --}}
                                            @can('mac-customer_destroy')
                                                <form method="POST" action="{{ route('clients.destroy', $r->id) }}">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button
                                                        onclick="return confirm('Are you sure you want to Delete this user ?');"
                                                        type="submit" class="dropdown-item">Delete</button>
                                                </form>
                                            @endcan





                                        </div>
                                    </div>
                                @endif

                            </td>
                    @endforeach
                    @foreach ($delete as $r)
                        <tr @if ($r->clients_status == 'deactive') class="deactive" @endif>

                            <td class="text-center">
                                <a class="btn btn-info btn-block btn-xs text-nowrap"
                                    href="{{ route('getPaymentHistory', $r->id) }}">CID: {{ $r->id }}</a>
                                @if (checkAPI() == false)
                                    <a href="{{ route('getCustomerLogHistory', $r->userid) }}"
                                        class="noprint btn btn-primary btn-xs btn-block">Log</a>
                                @endif

                                <a href="{{ route('clients.show', $r->id) }}"
                                    class="noprint btn btn-primary btn-xs btn-block">Details</a>

                            </td>
                            <td class="no-wrap">
                                {{ $r->userid }}
                                <br>
                                {{-- {{ $r->password }} --}}


                            </td>

                            <td
                                class="
                                @if ($r->deleted_at != null || $r->clients_status == 'expired') deactive bg-danger
                                @elseif($r->clients_status == 'deactive')
                                    bg-secondary
                                    @elseif($r->clients_status == 'disable')
                                    bg-warning
                                @elseif($r->clients_status == 'active')
                                bg-success @endif
                                ">
                                <x-Custom.Status status="{{ $r->clients_status }}" />
                            </td>
                            <td class=" @if ($r->deleted_at != null || $r->clients_status == 'expired') deactive bg-danger
                                            @elseif($r->clients_status == 'deactive') bg-secondary
                                            @elseif($r->clients_status == 'disable') bg-warning
                                            @elseif($r->clients_status == 'active')  bg-success @endif "
                                style="min-width:140px;text-align:left">
                                BD: {{ date('d-M-Y', strtotime($r->expire_date)) }}<br>
                                PD:
                                {{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}
                            </td>


                            <td style="min-width:130px">
                                <p style="font-size:14px;">
                                    B Cycle: {{ $r->billing_cycle }} <br>
                                    @if (isset($r->pop->bill_generate) && $r->pop->bill_generate == 'yes')
                                        B Amount: @role('Sub Reseller')
                                            @if ($r->pop->subreseller == 'yes')
                                                {{ $r->subpack->rate ?? 0 }}
                                            @else
                                                {{ $r->packages->package_rate }}
                                            @endif
                                        @else
                                            {{ $r->packages->package_rate }}
                                        @endrole <br>
                                        OTC : {{ $r->clientsinfo->otc ?? 0 }} <br>
                                        @if (isset($r->clientsinfo->otc_due))
                                            @if ($r->clientsinfo->otc_due > 0)
                                                <span class="bg-danger pl-1 pr-1"> OTC Due:
                                                    {{ $r->clientsinfo->otc_due ?? 0 }}</span>
                                            @endif
                                        @endif
                                    @endif
                                </p>

                                @if ($r->pop->bill_generate == 'yes')
                                    <p class="text-danger">Due: {{ $r->customerAccount->dueAmount ?? 0 }}</p>
                                @endif
                            </td>


                            <td>

                                @can('show-sub-package')
                                    <span class="d-block mb-1 badge badge-info">{{ $r->subpack->name ?? '' }}</span>
                                @endcan

                                @can('show-mother-package')
                                    <span class="d-block badge badge-info">
                                        {{ $r->packages->package_name ?? '' }}</span>
                                @endcan




                            </td>

                            <td class="no-wrap">
                                {{ $r->pop->popname ?? '' }}
                            </td>

                            <td>

                                {{ $r->clientsinfo->clients_name ?? '' }}
                            </td>
                            <td>
                                {{ $r->clientsinfo->contact_no ?? '' }}
                            </td>



                            <td style="width:350px;">
                                <p style="font-size:14px;">
                                    @if ($r->clientsinfo->flat_no)
                                        Flat No: {{ $r->clientsinfo->flat_no ?? '' }},
                                    @endif
                                    @if ($r->clientsinfo->building_name)
                                        Building Name: {{ $r->clientsinfo->building_name ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->road_no)
                                        Road No: {{ $r->clientsinfo->road_no ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->block_sector)
                                        Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }},
                                    @endif
                                    @if ($r->clientsinfo->area)
                                        Area : {{ $r->clientsinfo->area ?? '' }}, <br>
                                    @endif
                                    @if ($r->clientsinfo->box)
                                        Box : {{ $r->clientsinfo->box ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->client_latitude)
                                        Latitude : {{ $r->clientsinfo->client_latitude ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->client_longitude)
                                        Longitude : {{ $r->clientsinfo->client_longitude ?? '' }}
                                    @endif
                                </p>
                            </td>

                            <td>
                                {{ $r->clientsinfo->remarks ?? '' }}
                            </td>

                            
                            <td class="text-center noprint" style="width:160px;">

                                @if ($r->deleted_at != null)
                                    <div class="dropdown">
                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">


                                            <a href="{{ route('clients.show', $r->id) }}"
                                                class="dropdown-item">Details</a>


                                            <div class="mb-1"></div>

                                            @can('can-open')
                                                <a href="{{ route('open', $r->id) }}"
                                                    onclick="return confirm('Are you sure you want to Open the ID?');"
                                                    class="confirmDisable dropdown-item bg-danger">Restore Account</a>
                                            @endcan

                                        </div>
                                    </div>
                                @else
                                    <div class="dropdown">



                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">




                                            @can('add-otc')
                                                @if (isset($r->clientsinfo->otc_due))
                                                    @if ($r->clientsinfo->otc < 1)
                                                        <button type="button" class="dropdown-item addOtc"
                                                            data-toggle="modal" data-id="{{ $r->id }}"
                                                            data-target="#addOtc">
                                                            Add Otc
                                                        </button>
                                                    @endif
                                                @endif
                                            @endcan


                                            <a href="{{ route('clients.show', $r->id) }}"
                                                class="dropdown-item">Details</a>

                                            @can('mac-customer_edit')
                                                <a href="{{ route('clients.edit', $r->id) }}" class="dropdown-item">Edit</a>
                                            @endcan

                                            @can('changeBillCycle')
                                                <button type="button" class="dropdown-item clientBillCycleChange"
                                                    data-toggle="modal" data-id="{{ $r->id }}"
                                                    data-curdate={{ $r->billing_cycle }} data-target="#billCycleChange">
                                                    Bill Cycle Change
                                                </button>
                                            @endcan


                                            <div class="mb-1"></div>





                                            @if ($r->client_approval == 'pending')
                                                @can('new-customer-approve')
                                                    <form method="POST" action="{{ route('clinetApprove', $r->id) }}">
                                                        @method('post')
                                                        @csrf
                                                        <input type="hidden" name="user_approve"
                                                            value="{{ $r->id }}">
                                                        <button
                                                            onclick="return confirm('Are you sure you want to Approved this user ?');"
                                                            type="submit" class="dropdown-item">Approve</button>
                                                    </form>
                                                @endcan
                                            @endif

                                            @if ($r->clients_status == 'disable')
                                                @can('id-enable')
                                                    <a href="{{ route('idEnable', $r->id) }}"
                                                        onclick="return confirm('Are you sure you want to Enable the ID?');"
                                                        class="dropdown-item">Enable</a>
                                                @endcan
                                            @endif

                                            @if ($r->clients_status == 'active')
                                                @can('id-disable')
                                                    <a href="{{ route('idDisable', $r->id) }}"
                                                        onclick="return confirm('Are you sure you want to Disable the ID?');"
                                                        class="confirmDisable dropdown-item">Disable</a>
                                                @endcan
                                            @endif

                                            @can('can-close')
                                                <a href="{{ route('close', $r->id) }}"
                                                    onclick="return confirm('Are you sure you want to Close the ID?');"
                                                    class="confirmDisable dropdown-item">Close</a>
                                            @endcan

                                            {{-- @can('mac_customer_destroy') --}}
                                            @can('mac-customer_destroy')
                                                <form method="POST" action="{{ route('clients.destroy', $r->id) }}">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button
                                                        onclick="return confirm('Are you sure you want to Delete this user ?');"
                                                        type="submit" class="dropdown-item">Delete</button>
                                                </form>
                                            @endcan





                                        </div>
                                    </div>
                                @endif

                            </td>
                    @endforeach

                    {{-- <tr>
                    <td colspan="11">Total Deactive Client: {{$count}}</td>
                </tr> --}}

                </tbody>

            </table>

        </div>
    </div>

@endsection



@section('ajax')
    <script type="text/javascript">
        $(function() {
            // $('#reset').click(function() {
            //     $('#deactiveResult').html('');
            //     $('#pop').html('<option value="all">Select One</option>');
            // });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('leftClientSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        // console.log(result);
                        $('#leftClientResult').html(result);
                        $('#processing').remove();

                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>
@endsection
