<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;


class ExportTokenReport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function headings(): array
    {
        return [
            'Name',
            'Total Token',
            'Lowest Time',
            'Highest Time',
            'Average Time',
        ];
    }

    protected $data;
    protected $day;

    function __construct($data, $day)
    {
        $this->data = $data;
        $this->day = $day;
    }

    public function collection()
    {
        $items = [];
        if ($this->day == 7) {
            foreach ($this->data as $row) {
                $items[] = [
                    $row['name'],
                    $row['total_token_last_7_days'],
                    $row['lowestCloseTimeLast7Days'],
                    $row['highestCloseTimeLast7Days'],
                    $row['averageCloseTime7days'],
                ];
            }
        } elseif ($this->day == 30) {
            foreach ($this->data as $row) {
                $items[] = [
                    $row['name'],
                    $row['total_token_last_30_days'],
                    $row['lowestCloseTimeLast30Days'],
                    $row['highestCloseTimeLast30Days'],
                    $row['averageCloseTime30days'],
                ];
            }
        }

        return collect($items);
    }
}
