<?php

namespace App\Mail;

use App\Models\MailLog;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Symfony\Component\VarDumper\VarDumper;
use Illuminate\Contracts\Queue\ShouldQueue;
use niklasravnsborg\LaravelPdf\Facades\Pdf;

class InvoiceSend extends Mailable
{
    use Queueable, SerializesModels; 

    /**
     * Create a new message instance.
     *
     * @return void
     */

    public $data;
    public $message;
    public $client;
    

    public function __construct($data, $message,$client)
    {
        $this->data = $data;
        $this->message = $message;
        $this->client = $client;
    }   

    /**
     * Build the message.
     *
     * @return $this
     */

    public function attachments()
    {
        
        $attachments = PDF::loadView('customerInvoice.singleinvoice', $this->data)->output();
        return $attachments;
    }

    public function build()
    {       
        
        $setting = json_decode(emailSetting()->where('tamplate_name', 'bill_generate_eamil')->first()->email_body);       

        if ($setting->sendemail == 'Yes') {           

            return $this->view('customerInvoice.mail.billGenerate', [
                'info' => $this->message,
            ])->attachData($this->attachments(), 'invoice.pdf', [
                'mime' => 'application/pdf',
            ])->subject('Invoice for ' .siteinfo()->name. ' Bill month of '.today()->format('M-Y'));
        }
    }
}
