<?php

namespace App\Observers;

use App\Models\GlobalSettings;
use Illuminate\Support\Facades\Cache;

class GlobalSettingsObserver
{
    /**
     * Handle the GlobalSettings "created" event.
     *
     * @param  \App\Models\GlobalSettings  $globalSettings
     * @return void
     */
    public function created(GlobalSettings $globalSettings)
    {
        Cache::forget('globalSettings');
    }

    /**
     * Handle the GlobalSettings "updated" event.
     *
     * @param  \App\Models\GlobalSettings  $globalSettings
     * @return void
     */
    public function updated(GlobalSettings $globalSettings)
    {
        Cache::forget('globalSettings');
    }

    /**
     * Handle the GlobalSettings "deleted" event.
     *
     * @param  \App\Models\GlobalSettings  $globalSettings
     * @return void
     */
    public function deleted(GlobalSettings $globalSettings)
    {
        Cache::forget('globalSettings');
    }

    /**
     * Handle the GlobalSettings "restored" event.
     *
     * @param  \App\Models\GlobalSettings  $globalSettings
     * @return void
     */
    public function restored(GlobalSettings $globalSettings)
    {
        Cache::forget('globalSettings');
    }

    /**
     * Handle the GlobalSettings "force deleted" event.
     *
     * @param  \App\Models\GlobalSettings  $globalSettings
     * @return void
     */
    public function forceDeleted(GlobalSettings $globalSettings)
    {
        Cache::forget('globalSettings');
    }
}
