<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TokenSourceSeeder extends Seeder
{
    public function run()
    {
        $source = [
            ['id' => '1', 'name' => 'CRM'],
            ['id' => '2', 'name' => 'Marketing'],
            ['id' => '3', 'name' => 'Tele Sales'],
            ['id' => '4', 'name' => 'Seniors'],
            ['id' => '5', 'name' => 'Call Center 44299'],
            ['id' => '6', 'name' => 'Call Center 55225'],
            ['id' => '7', 'name' => 'Call Center 55177'],
            ['id' => '8', 'name' => 'Call Center 55102'],
            ['id' => '9', 'name' => 'Call Center 44999'],
            ['id' => '10', 'name' => 'Call Center 86567'],
            ['id' => '11', 'name' => 'Call Center 55155'],
            ['id' => '12', 'name' => 'Call Center 55888'],
            ['id' => '13', 'name' => 'Call Center 55689'],
            ['id' => '14', 'name' => 'Call Center 55122'],
            ['id' => '15', 'name' => 'Call Center Other Phone'],
            ['id' => '16', 'name' => 'Hotline 800900'],
            ['id' => '17', 'name' => 'Short Code'],
            ['id' => '18', 'name' => 'Whatsapp Group'],
            ['id' => '19', 'name' => 'Employee Personal Phone'],
            ['id' => '20', 'name' => 'Mail'],
        ];

        foreach ($source as $item) {
            unset($item['id']);
            if (DB::table('token_sources')->where('name', $item['name'])->count() < 1) {
                DB::table('token_sources')->insert($item);
            }
        }
    }
}
