@extends('layout.app')
@section('content')
    <div class="mt-2" id="vue_app">

        <form action="{{ route('requisition.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="card">
                <div class="card-body">

                    <!-- Search by name/code -->
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label for="name">Enter Name / code</label>
                            <input type="text" name="name" id="name" class="form-control"
                                placeholder="Search Name/code" @keyup="fetch_item()" v-model="search_keyword"
                                autocomplete="off">
                            @error('name')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                            <ul class="list-group">
                                <li style="cursor: pointer;" class="form-control" @click="select_item(result.id)"
                                    v-for="(result, index) in results">
                                    <a>@{{ result.name }} (@{{ result.code }})</a>
                                </li>
                            </ul>
                        </div>

                        <div class="form-group col-md-4">
                            <label for="category_id">Category</label>
                            <select name="category_id" id="category_id" class="form-control" v-model="category_id"
                                @change="fetch_product()">
                                <option value="">Select Category</option>
                                @foreach ($categories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                            @error('category_id')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">
                            <label for="product_id">Item</label>
                            <select name="product_id" id="product_id" class="form-control" v-model="product_id">
                                <option value="">Select Item</option>
                                <option :value="row.id" v-for="row in products" v-html="row.name"></option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <button type="button" class="mb-2 btn btn-success float-right" @click="data_input">Add</button>
                    </div>
                    <div v-if="items.length > 0">
                        <!-- Employee -->
                        <div class="form-group">
                            <label for="employee_id">Employee Name*</label>
                            <select name="employee_id" id="employee_id" class="form-control employee-select" required>
                                <option value="">Select Employee</option>
                                @foreach ($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->name }} ({{ $employee->mobile_office }})</option>
                                @endforeach
                            </select>
                            @error('employee_id')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Branch -->
                        <div class="form-group">
                            <label for="branch_id">Branch*</label>
                            <select name="branch_id" id="branch_id" class="form-control" required>
                                <option value="">Select Branch</option>
                                @foreach ($branches as $branch)
                                    <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                @endforeach
                            </select>
                            @error('branch_id')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Item Table -->
                        <table id="dataTable" class="table table-bordered">
                            <tr>
                                <th>Item</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th>Quantity</th>
                                <th>Action</th>
                            </tr>
                            <tr v-for="(row, index) in items">
                                <td>
                                    <input type="hidden" :name="'products[' + index + '][item_id]'" :value="row.item_id">
                                    <input type="text" class="form-control" :value="row.item_name" readonly>
                                </td>
                                <td><input type="text" class="form-control" :value="row.category" readonly></td>
                                <td><input type="text" class="form-control" :value="row.unit" readonly></td>
                                <td>
                                    <input type="number" v-model="row.quantity" :name="'products[' + index + '][quantity]'"
                                        class="form-control" @change="itemtotal(row)" required>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger" @click="delete_row(row)">
                                        <i class="fa fa-times"></i>
                                    </button>
                                </td>
                            </tr>
                        </table>

                        <!-- Other Fields -->

                        <div class="form-group">
                            <label>Remarks</label>
                            <textarea v-model="remark" class="form-control" name="remark" rows="3" placeholder="Enter Remarks"></textarea>
                            @error('remark')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Location*</label>
                            <textarea v-model="location" class="form-control" name="location" rows="3"
                                placeholder="Enter Your Location Details" required></textarea>
                            @error('location')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Purposes*</label>
                            <textarea v-model="purposes" class="form-control" name="purposes" rows="3" placeholder="Enter Your Purposes"
                                required></textarea>
                            @error('purposes')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Recommendation</label>
                            <textarea v-model="recommendation" class="form-control" name="recommendation" rows="3"
                                placeholder="Enter Your Recommendation"></textarea>
                            @error('recommendation')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Upload File For Authorization</label>
                            <input v-model="auth_file" type="file" name="auth_file" class="form-control">
                            @error('auth_file')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <button class="btn btn-success float-right" type="submit">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection

@push('css')
    <link rel="stylesheet" href="{{ asset('/') }}plugins/select2/css/select2.min.css">
@endpush

@push('js')
    <script src="{{ asset('vue-js/vue/dist/vue.js') }}"></script>
    <script src="{{ asset('vue-js/axios/dist/axios.min.js') }}"></script>
    <script src="{{ asset('vue-js/bootstrap-select/dist/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('/') }}plugins/select2/js/select2.full.min.js"></script>

    <script>
        $(document).ready(function() {
            var app = new Vue({
                el: '#vue_app',
                data: {
                    config: {
                        get_keyword_wise_item_url: "{{ url('admin/fetch-item-by-search-keyword') }}",
                        get_item_by_id_url: "{{ url('admin/fetch-item-by-item-id') }}",
                        get_category_wise_product_url: "{{ url('admin/fetch-item-by-category-id') }}"
                    },
                    category_id: '',
                    product_id: '',
                    products: [],
                    search_keyword: '',
                    results: [],
                    items: [],
                    remark: '',
                    recommendation: '',
                    purposes: '',
                    location: '',
                    auth_file: ''
                },
                methods: {
                    fetch_item() {
                        const vm = this;
                        if (vm.search_keyword) {
                            axios.get(vm.config.get_keyword_wise_item_url + '/' + vm.search_keyword)
                                .then(response => {
                                    vm.results = response.data;
                                });
                        }
                    },
                    fetch_product() {
                        const vm = this;
                        if (vm.category_id) {
                            axios.get(vm.config.get_category_wise_product_url + '/' + vm.category_id)
                                .then(response => {
                                    vm.products = response.data;
                                });
                        }
                    },
                    select_item(id) {
                        const vm = this;
                        axios.get(vm.config.get_item_by_id_url + '/' + id)
                            .then(response => {
                                const item = response.data;
                                vm.items.push({
                                    item_id: item.id,
                                    item_name: item.name,
                                    unit: item.unit.name,
                                    quantity: 1,
                                    price: 0,
                                    itemtotal: 0,
                                    category: item.category.name,
                                });
                                vm.search_keyword = '';
                                vm.results = [];
                            });
                    },
                    data_input() {
                        const vm = this;
                        if (vm.product_id) {
                            axios.get(vm.config.get_item_by_id_url + '/' + vm.product_id)
                                .then(response => {
                                    const item = response.data;
                                    vm.items.push({
                                        item_id: item.id,
                                        item_name: item.name,
                                        unit: item.unit.name,
                                        quantity: 1,
                                        price: 0,
                                        itemtotal: 0,
                                        category: item.category.name,
                                    });
                                    vm.category_id = '';
                                    vm.product_id = '';
                                    vm.results = [];
                                });
                        }
                    },
                    delete_row(row) {
                        this.items.splice(this.items.indexOf(row), 1);
                    },
                    itemtotal(index) {
                        return index.quantity * index.price;
                    }
                },
                mounted() {
                    $('#employee_id').select2({
                        width: '100%',
                        placeholder: 'Select an Employee'
                    });

                    $('#branch_id').select2({
                        width: '100%',
                        placeholder: 'Select a Branch'
                    });

                    $('#product_id').select2({
                        width: '100%',
                        placeholder: 'Select an Item'
                    });
                },
                updated() {
                    $('.bSelect').selectpicker('refresh');

                    $('#employee_id').select2({
                        width: '100%',
                        placeholder: 'Select an Employee'
                    });

                    $('#branch_id').select2({
                        width: '100%',
                        placeholder: 'Select a Branch'
                    });

                    $('#product_id').select2({
                        width: '100%',
                        placeholder: 'Select an Item'
                    }).on('change', (e) => {
                        this.product_id = e.target.value;
                    });
                }

            });
        });
    </script>
@endpush
