<?php

namespace App\Http\Controllers;

use App\Models\Unit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UnitController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:unit_index|unit_create',['only' => ['index','create']]);
        $this->middleware('permission:unit_create',['only' => ['index','create']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Unit::paginate('100');
        return view('unit.index',[
            'page_title' => 'Unit List',
            'list' => $list,
            'url' => route('unit.create'),
            'add_button' => 'true',
            'class' => 'btn btn-primary',
            'value' => 'Add New Unit'
             ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('unit.create',[
            'page_title'=> 'Add New Unit'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:units',
            'short_name' => 'nullable',
            'remarks' => 'nullable',
        ]);

        $unit = new Unit();
        $unit->fill($request->all());
        $unit->creator_user_id = Auth::id();
        $unit->save();
        $request->session()->flash('success_message', 'Unit Added successfull');
        return redirect()->route('unit.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Unit  $unit
     * @return \Illuminate\Http\Response
     */
    public function show(Unit $unit)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Unit  $unit
     * @return \Illuminate\Http\Response
     */
    public function edit(Unit $unit)
    {

        return view('unit.update',[
            'list' => $unit,
            'page_title' => 'Update Unit Information'
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Unit  $unit
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Unit $unit)
    {
        $this->validate($request, [
            'name' => 'required|unique:units,name,' . $unit->id,
            'short_name' => 'nullable',
            'remarks' => 'nullable',
        ]);
        $unit->fill($request->all());
        $unit->updator_user_id = Auth::id();
        $unit->save();
        $request->session()->flash('success_message', 'Unit Updated Successfull');
        return redirect()->route('unit.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Unit  $unit
     * @return \Illuminate\Http\Response
     */
    public function destroy(Unit $unit)
    {
        $unit->delete();
        session()->flash('success_message', 'Unit Deleted Successful');
        return redirect()->route('unit.index');
    }
}
