@extends('layout.app')


@section('content')


    <form action="{{ route('branch.store') }}" method="POST">

        @csrf
        <div class="card">
            <div class="card-body">
                <div class="row">
                <div class="form-group col-md-4">
                    <label for="name" class="">
                        Name*
                    </label>
                    <input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control"
                        placeholder=" Name" autocomplete="off" autofocus>
                    @error('name')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="contact_no" class="">
                        Contact
                    </label>
                    <input type="text" name="contact_no" id="concontact_notact" value="{{ old('contact_no') }}"
                        class="form-control" placeholder="Contact" autocomplete="off" autofocus>
                    @error('contact_no')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="address" class="">
                        Address
                    </label>
                    <input type="text" name="address" id="address" value="{{ old('address') }}"
                        class="form-control" placeholder=" Address" autocomplete="off" autofocus>
                    @error('address')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
                <div class="form-group">
                    @can('inventory-group_store')
                        <button type="submit"
                            class="btn btn-success float-right">
                            Save
                        </button>
                    @endcan
                </div>
            </div>
        </div>
    </form>

    <div class="p-5"></div>

@endsection
