<?php

namespace App\Services;

use App\Http\Controllers\SessionRefreshController;
use App\Models\Client;
use App\Models\ClientEditLog;
use App\Models\Pop;
use App\Models\SubPackage;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class BatchExpChangeService
{
    public function batchExpChange($user, $exp_date, $auth_user)
    {
        DB::beginTransaction();
        try {
            $client = Client::find($user->id);
            $old_client_data = Client::with('clientsinfo')->find($user->id);

            $client->expire_date = $exp_date;
            $client->billing_cycle = Carbon::parse($exp_date)->format('d');
            $client->payment_dadeline = 0;
            if (Carbon::parse(Carbon::parse($exp_date)) < today()) {
                $client->clients_status = 'expired';
            } else {
                $client->clients_status = 'active';
            }
            $client->update();

            $new_client_data = Client::with('clientsinfo')->find($user->id);

            $client_update_log = new ClientEditLog();
            $client_update_log->client_id = $user->id;
            $client_update_log->user_id = $auth_user;
            $client_update_log->old_data = json_encode($old_client_data);
            $client_update_log->new_data = json_encode($new_client_data);
            $client_update_log->save();

            $client = Client::with('pop')->find($user->id);




            if(globalPermission('RadiusExpiration')){

                (new ExpirationService())->handleExpiration($client->userid,$old_client_data->expire_date,$client->payment_dadeline,$client->pop->experity_check);
            }

            DB::commit();

            return response()->json([
                'message' => 'Expire Date Changed Successfully',
                'status' => 'success',
            ]);
        } catch (\Throwable $th) {

            DB::rollback();
            return response()->json([
                'message' => $th->getMessage(),
                'status' => 'error'
            ]);
        }
    }

    public function batchPackChange($user, $auth_user, $pack)
    {
        DB::beginTransaction();
        try {
            $client = Client::find($user->id);
            $pop = Pop::find($client->pop_id);
            $subpack = SubPackage::find($pack);
            $old_client_data = Client::with('clientsinfo')->find($user->id);

            if($pop->subreseller != 'yes'){

                $client->package_id = $pack;
            } else if($pop->subreseller == 'yes'){

                $client->package_id = $subpack->package_id;
                $client->sub_package_id = $subpack->id;
            }

            $client->update();

            $new_client_data = Client::with('clientsinfo')->find($user->id);

            $client_update_log = new ClientEditLog();
            $client_update_log->client_id = $user->id;
            $client_update_log->user_id = $auth_user;
            $client_update_log->old_data = json_encode($old_client_data);
            $client_update_log->new_data = json_encode($new_client_data);
            $client_update_log->save();

            $client = Client::find($user->id);

            if(!checkAPI()){

                DB::table('radusergroup')->where('username', $client->userid)->update([
                    'groupname' => $client->package_id,
                ]);
            }


            DB::commit();

            return response()->json([
                'message' => 'Package Changed Successfully',
                'status' => 'success',
            ]);
        } catch (\Throwable $th) {

            DB::rollback();
            return response()->json([
                'message' => $th->getMessage(),
                'status' => 'error'
            ]);
        }
    }
}
