@extends('layout.app')


@section('content')

    <div class="row">
        <div class="col-sm-6">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('user-recharge-update',$user->id) }}" method="POST">
                        @csrf


                        <p class="p-2">User Name: {{ $user->name }}</p>
                        <p class="p-2">Current Balance: {{ $user->user_balance }}</p>

                        <div class="form-group">
                            <label for="amount">Amount</label>

                            <input type="number" name="amount" placeholder="0" class="form-control" required>
                            @error('amount')<div class="text-red-500 mt-2 text-sm">{{ $message }}</div>@enderror

                        </div>

                        <div class="form-group">

                            <label for="remark">Remark</label>
                            <input type="text" name="remarks" class="form-control" required>
                            @error('remark')<div class="text-red-500 mt-2 text-sm">{{ $message }}</div>@enderror

                        </div>


                        <input type="hidden" value="{{ $user->id }}" name="type_id">
                        <div class="from-group">
                            <a href="{{ route('user.index') }}" class="btn btn-default float-lef"><i
                                    class="fa fa-arrow-left"></i> Back</a>
                            <button class="btn btn-primary float-right" type="submit">Recharge</button>
                        </div>



                    </form>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Reseller Recharge History </p>

                    <div class="form-group">
                        <div class="table-responsive">
                        <table class="table">
                            <thead class="bg-blue-50">
                                <tr>
                                    
                                            <th scope="
                                        col"
                                        class="">
                                                Date
                                            </th>

                                            <th scope="
                                        col"
                                        class="">
                                                Amount
                                            </th>

                                            <th scope="
                                        col"
                                        class="">
                                                After Recharge Balance
                                            </th>

                                            <th scope="
                                        col"
                                        class="">
                                                Remarks
                                            </th>
                                            <th scope="
                                        col"
                                        class="">
                                                Recharge By
                                            </th>
                                            <th scope="
                                        col"
                                        class="">

                                            </th>
                                </tr>
                            </thead>
                            <tbody class="
                                        bg-white divide-y divide-gray-200">

                                        @foreach ($rechargeList as $r)

                                        {{-- {{$r}} --}}

                                <tr>
                                   
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                                    </td>



                                    <td class="px-6 py-4 whitespace-nowrap text-right">
                                        {{ $r->amount }}
                                    </td>


                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">
                                        {{ $r->after_recharge_balance }}
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $r->remarks }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $r->recharge_by_user->name }}
                                    </td>


                                </tr>

                                @endforeach
                                </tbody>
                        </table>
                        </div>





                    </div>
                </div>
            </div>
        </div>

    </div>





@endsection
