import { Button } from 'react-bootstrap';

import styles from './DrawButton.module.css';
import { useDispatch, useSelector } from 'react-redux';
import { toggleDraw } from '../../../store/reducers/coordinatesReducer';

const ToggleButton = () => {
    const dispatch = useDispatch();
    const { drawOnMap } = useSelector((state) => state.coordinatesReducer);

    const onToggleHandler = () => dispatch(toggleDraw());

    return drawOnMap ? (
        <Button
            variant='danger'
            className={styles.draw_button}
            onClick={onToggleHandler}
        >
            Stop Drawing
        </Button>
    ) : (
        <Button
            variant='success'
            className={styles.draw_button}
            onClick={onToggleHandler}
        >
            Draw On Map
        </Button>
    );
};

export default ToggleButton;
