@extends('layout.app')


@section('content')

    <div class="card">
        <div class="card-body">
            <button class="btn btn-primary" onclick="window.print()"><i class="fa fa-print"></i>Print</button>
            <div class="mt-3">
                <a class="" href="{{ url()->previous() }}"> <i class="fa fa-arrow-left"></i> Back</a>
                <div class=" ">
                    <h5>Purchase Information</h5>
                    <table id="dataTable" class="table table-bordered">
                        <tr>
                            <th colspan="6" class="text-center">Voucher No#{{ $purchase->voucher_no }}</th>
                        </tr>
                        <tr>
                            <th colspan="6" class="text-center">Invoice No#{{ $purchase->invoice_number }}</th>
                        </tr>
                        <tr>
                            <th> Net Payable</th>
                            <td>{{ $purchase->subtotal }}</td>
                            <th>Paid</th>
                            <td>{{ $purchase->paid }}</td>
                            <th>Due</th>
                            <td>{{ $purchase->due }}</td>
                        </tr>
                    </table>
                    <h5>Payment Information</h5>
                    <table id="dataTable" class="table table-bordered">
                        @foreach ($purchase->payments as $row)
                            <tr>
                                <th>Cheque Number</th>
                                <td>{{ $row->cheque_number }}</td>
                                <th>Account Number</th>
                                <td>{{ $row->account_number }}</td>
                                <th>Branch Name</th>
                                <td>{{ $row->branch }}</td>
                                <th>Bank Name</th>
                                <td>{{ $row->bank_name }}</td>
                                <th>Amount</th>
                                <td>{{ $row->amount }}</td>
                            </tr>
                        @endforeach
                    </table>
                    <h5>Items</h5>
                    <table id="dataTable" class="table table-bordered">
                        <tr>
                            <th>Item</th>
                            <th>Category</th>
                            <th>Unit</th>
                            <th>Quantity</th>
                            <th>Price(BDT)</th>
                            <th>Item Total(BDT)</th>
                        </tr>
                        @foreach ($purchase->items as $row)
                            <tr>
                                <td>{{ $row->item->name ?? '' }}</td>
                                <td>{{ $row->item->category->name ?? '' }}</td>
                                <td>{{ $row->item->unit->name ?? '' }}</td>
                                <td>{{ $row->quantity ?? '' }}</td>
                                <td>{{ $row->buying_price ?? '' }}</td>
                                <td>{{ $row->buying_price * $row->quantity }}</td>
                            </tr>
                        @endforeach
                        <tr>
                            <th>Remarks</th>
                            <td colspan="5">{{ $purchase->remark ?? '' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>



@endsection
