<?php

namespace App\Jobs;

use App\Services\ClientCloseService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MakeClientCloseJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $client;
    private $details;
    private $authUserId;
    public function __construct($client, $details, $authUserId)
    {
        $this->client = $client;
        $this->details = $details;
        $this->authUserId = $authUserId;
    }

    public function handle()
    {
        (new ClientCloseService)->close($this->client, $this->details, $this->authUserId);
    }
}
