<?php

namespace App\Classes;

use Carbon\Carbon;
use App\Models\User_log;
use Illuminate\Support\Facades\DB;
use App\Jobs\ExpireCustomerDeactiveByListJob;
use App\Models\Client;

class ExpireCustomerDeactive
{


  public function deactiveBatch($lists, $authId = null)
  {
    foreach ($lists as $l) {

      // dd($l);



      $start = today()->firstOfMonth();
      $end = today()->endOfMonth();

      if(Carbon::parse($l->expire_date) < $end){
          $bill = DB::table('bill_generates')
            ->where('client_id', $l->id)
            ->whereBetween('created_at', [$start, $end])
            ->where('billing_type', 'monthly')
            ->first();

          if ($bill == null) {



            if (Carbon::parse($l->expire_date) >= $start && Carbon::parse($l->expire_date) <= $end && $l->clients_status != 'deactive') {

              DB::table('clients')->where('id', $l->id)->update(['clients_status' => 'deactive']);

              User_log::create([
                'log_type' => 'id_deactive',
                'user_id' => $authId,
                'details' => 'auto deactive',
                'client_id' => $l->id
              ]);
            }
            //   continue;
          }




          if ($bill) {
            (new \App\Http\Controllers\BillGenerateController)->monthlyBillFix(request(), $bill->id, $authId);
          }

          // DB::table('clients')->where('id', $l->id)->update(['clients_status' => 'deactive']);

          if (Carbon::parse($l->expire_date) >= today()->firstOfMonth() && Carbon::parse($l->expire_date) <= today()->endOfMonth() && $l->clients_status != 'deactive') {

            DB::table('clients')->where('id', $l->id)->update(['clients_status' => 'deactive']);

            User_log::create([
              'log_type' => 'id_deactive',
              'user_id' => $authId,
              'details' => 'auto deactive',
              'client_id' => $l->id
            ]);
          }

          DB::table('clients')->where('id', $l->id)->where('clients_status','expired')->update(['clients_status' => 'deactive']);

         
      }


    }
  }

  public function deactive($days)
  {




    // $lists = DB::table('clients')
    //   ->leftJoin('pops', 'clients.pop_id', '=', 'pops.id')
    //   ->whereRaw("DATE_ADD(expire_date,INTERVAL payment_dadeline DAY) < DATE_SUB(CURDATE() , interval $days day) ")
    //   ->select('clients.id', 'clients.expire_date', 'clients.clients_status')
    //   ->where('pops.bill_generate', 'yes')
    //   ->where('pops.experity_check', 'No')
    //   ->get();

    // dd($lists);


    // dd($lists->count());

    // DB::table('clients')
    // ->leftJoin('pops', 'clients.pop_id', '=', 'pops.id')
    // ->whereRaw("DATE_ADD(expire_date,INTERVAL payment_dadeline DAY) < DATE_SUB(CURDATE() , interval $days day) ")
    // ->select('clients.id', 'clients.expire_date', 'clients.clients_status')
    // ->where('pops.bill_generate', 'yes')
    // ->where('pops.experity_check', 'No')
    // ->chunk(100, function ($clients) {
    //     dispatch(new ExpireCustomerDeactiveByListJob($clients));
    // });


  }
}
