@extends('layout.app')
@section('content')

    <div class="" id="vue_app">

        <form action="{{ route('requisition-approves.store') }}" method="POST" id="approveReqisitionForm">
            @csrf
            <div class="mt-2 card">
                <div class="card-body">
                    <input type="hidden" id="requisition_id" name="requisition_id" value="{{$requisition_id}}">

                    <div class="" >
                        <div class="table-responsive">
                        <table id="datatable" class="table table-bordered">
                            <tr>
                                <th>Item</th>
                                <th>Stock Qty</th>
                                <th>Requisition Qty</th>
                                <th>Approve Qty</th>
                                <th>Serial Number</th>

                            </tr>
                            @foreach ($requisition->items as $item)
                                <tr>
                                    <td>{{$item->item->name}}</td>
                                    <td>{{ \App\Classes\AvailableStockCalculation::item_id($item->item_id) }}</td>
                                    <td>{{$item->quantity}}</td>
                                    <td>
                                        <input type="number" class="qty" name="approve_qty[]" max="{{$item->quantity}}" min="0" required>
                                        <input type="hidden" class="item_id" name="item_id[]" value="{{$item->item->id}}">
                                        <input type="hidden" class="status" name="item_status[]" value="{{$item->item->serial_number}}">

                                    </td>
                                    <td>

                                            <select style="width: 250px" class="form-select js-example-basic-single serial_all"  name="serial[{{$item->item->id}}][]" multiple="multiple">

                                                @foreach ($item->item->serialNumbers as $serialNumber)
                                                <option value="{{$serialNumber->id}}">{{$serialNumber->serial_no}}</option>
                                                @endforeach
                                            </select>

                                    </td>

                                </tr>

                            @endforeach

                        </table>
                        </div>
                    </div>
                    <div class="row" >

                        <div class="col-md-12 form-group">
                            <label class="">Remarks</label>
                            <textarea class="form-control" name="remark" rows="3" placeholder="Enter Remarks"></textarea>

                            <button class="mt-2 btn btn-success float-right" id="savebtn" type="submit"><i class="fa fa-save"></i>
                                Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    </div>
@endsection

@push('js')


<script src="{{ asset('/') }}js/jquery.validate.js"></script>

    <script>
        $(document).ready(function() {


            $('.js-example-basic-single').select2();

            $('#savebtn').on('click',function(e){
                e.preventDefault();

                $('#approveReqisitionForm').valid();

                var check=1;
                $("tr .qty").each(function(index,value){
                    tqty= $(this).parents("tr").find( "input.qty").val();
                    status= $(this).parents("tr").find( "input.status").val();
                    temSerial= $(this).parents("tr").find( ".serial_all").find(":selected");
                    if(status=="enable" && tqty!=temSerial.length)
                    {
                        check=0;

                    }

                });
                if(check==0){
                    toastr.error("Total serial no and Qty Not match");
                }else{

                    $('#approveReqisitionForm').submit();
                }

            });

        });
    </script>
@endpush
