<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Library\UddoktaPay;
use Illuminate\Http\Request;
use App\Models\UddoktaPayLog;
use Brian2694\Toastr\Facades\Toastr;

class UddoktapayController extends Controller {

    /**
     * Show the payment view
     *
     * @return void
     */
    public function show() {
        return view( 'customer.payment-form' );
    }

    /**
     * Initializes the payment
     *
     * @param Request $request
     * @return void
     */
    public function pay( Request $request ) {        

        $validatedData = $request->validate( [
            'full_name' => ['required', 'string'],
            'email'     => ['required', 'email'],
            'amount'    => ['required', 'integer'],
        ] );

        $requestData = [
            'full_name'    => $validatedData['full_name'],
            'email'        => $validatedData['email'],
            'amount'       => $validatedData['amount'],
            'metadata'     => [
                'customer_id'   => $request->customer_id,
            ],
            'redirect_url' => route( 'uddoktapay.success' ),
            'cancel_url'   => route( 'uddoktapay.cancel' ),
            'webhook_url'  => route('uddoktapay.webhook'),
        ];

        $res = UddoktaPay::init_payment( $requestData );       
        return $res;
    }

    /**
     * Reponse from sever
     *
     * @param Request $request
     * @return void
     */
    public function webhook( Request $request ) {  
        
        $UddoktaPayLog = new UddoktaPayLog();
        $UddoktaPayLog->customer_id = $request['metadata']['customer_id'];
        $UddoktaPayLog->transaction_id = $request['transaction_id'];
        $UddoktaPayLog->status = 'pending';
        $UddoktaPayLog->save();


        // $headerApi = isset( $_SERVER['RT_UDDOKTAPAY_API_KEY'] ) ? $_SERVER['RT_UDDOKTAPAY_API_KEY'] : null;

        $headerApi = $request->header( 'RT_UDDOKTAPAY_API_KEY' );

        // return response()->json( $headerApi );
        

        if ( $headerApi == null ) {
            return response( "Api key not found", 403 );
        }

        if ( $headerApi != env( "UDDOKTAPAY_API_KEY" ) ) {
            return response( "Unauthorized Action", 403 );
        }

        $validatedData = $request->validate( [
            'full_name'      => 'required',
            'email'          => 'required',
            'amount'         => 'required',
            'invoice_id'     => 'required',
            'metadata'       => 'required',
            'payment_method' => 'required',
            'sender_number'  => 'required',
            'transaction_id' => 'required',
            'status'         => 'required',
        ] );

        if($request->status == 'COMPLETED'){

            $status = (new PaymentController)->uddoktapay($validatedData,$UddoktaPayLog);

        }else{
            $status = 'Payment Failed';
        }

        


        

        
        return response()->json( $status );
    }

    /**
     * Success URL
     *
     * @return void
     */
    public function success() {

      //tostar
        Toastr::success('Payment Done!!', 'success');
        return redirect()->route('customerDashboard');
    }

    /**
     * Cancel URL
     *
     * @return void
     */
    public function cancel() {
        Toastr::error('Payment Cancelled!!', 'error');
        return redirect()->route('customerDashboard');
    }

}