<div class="card">
    <div class="card-body">
         <button id="downloadCsv" class=" btn btn-primary" >
            Download CSV
       </button>
        <h4>Total Offline: {{ checkAPI() ? sizeof($list) : count($list) }}</h4>
        @if (checkAPI())
            <table id="dataTable" class="table table-bordered">
                <thead style=" background-color: #78716c; color: #ffffff;">
                    <tr>
                        <th>Id</th>
                        <th>UserName </th>
                        <th>Client Status</th>
                        <th>Billing Date</th>
                        <th>Bill Info</th>
                        <th>Package</th>
                        <th>POP</th>
                        <th style="width:300px">User Info</th>
                        <th>Expire Date</th>
                        <th>Last Logout Time</th>

                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">

                    @foreach ($list as $r)

                        <tr>
                            <td class="text-center">
                                <a class="btn btn-info btn-block btn-xs text-nowrap"
                                    href="{{ route('getPaymentHistory', $r->id) }}">CID: {{ $r->id }}</a>
                            </td>
                            <td>{{ $r['userid'] }} <br>
                                @if (in_array('view-client-password', userPermissions()))
                                    <i class="fa fa-key" aria-hidden="true"></i> {{ $r->password }} <br>
                                @endif

                                Name: {{ $r->clientsinfo->clients_name ?? '' }} <br>
                                {{ $r->clientsinfo->contact_no ?? '' }}
                            </td>
                            <td
                                class=" @if ($r->deleted_at != null || $r->clients_status == 'expired') deactive bg-danger
                                    @elseif($r->clients_status == 'deactive')
                                        bg-secondary
                                    @elseif($r->clients_status == 'disable')
                                        bg-warning
                                    @elseif($r->clients_status == 'active')
                                        bg-success @endif">
                                <x-Custom.Status status="{{ $r->clients_status }}" />
                            </td>
                            <td
                                class=" @if ($r->deleted_at != null || $r->clients_status == 'expired') deactive bg-danger
                                    @elseif($r->clients_status == 'deactive')
                                        bg-secondary
                                    @elseif($r->clients_status == 'disable')
                                        bg-warning
                                    @elseif($r->clients_status == 'active')
                                        bg-success @endif
                                    "style="min-width:140px;text-align:left">
                                BD: {{ date('d-M-Y', strtotime($r->expire_date)) }}<br>
                                PD:
                                {{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}
                            </td>
                            <td style="min-width:130px">
                                <p style="font-size:14px;">
                                    B Cycle: {{ $r->billing_cycle }} <br>
                                    @if (isset($r->pop->bill_generate) && $r->pop->bill_generate == 'yes')
                                        B Amount: @role('Sub Reseller')
                                            @if ($r->pop->subreseller == 'yes')
                                                {{ $r->subpack->rate ?? 0 }}
                                            @else
                                                {{ $r->packages->package_rate }}
                                            @endif
                                        @else
                                            {{ $r->packages->package_rate }}
                                        @endrole <br>
                                        OTC : {{ $r->clientsinfo->otc ?? 0 }} <br>
                                        @if (isset($r->clientsinfo->otc_due))
                                            @if ($r->clientsinfo->otc_due > 0)
                                                <span class="bg-danger pl-1 pr-1"> OTC Due:
                                                    {{ $r->clientsinfo->otc_due ?? 0 }}</span>
                                            @endif
                                        @endif
                                    @endif
                                </p>

                                @if ($r->pop->bill_generate == 'yes')
                                    <p class="text-danger">Due: {{ $r->customerAccount->dueAmount ?? 0 }}</p>
                                @endif
                            </td>
                            <td>

                                @can('show-sub-package')
                                    <span class="d-block mb-1 badge badge-info">{{ $r->subpack->name ?? '' }}</span>
                                @endcan

                                @can('show-mother-package')
                                    <span class="d-block badge badge-info"> {{ $r->packages->package_name ?? '' }}</span>
                                @endcan

                            </td>

                            <td class="no-wrap">
                                {{ $r->pop->popname ?? '' }}
                            </td>
                            <td style="width:300px;">
                                <p style="font-size:14px;">
                                    @if ($r->clientsinfo->flat_no)
                                        Flat No: {{ $r->clientsinfo->flat_no ?? '' }},
                                    @endif
                                    @if ($r->clientsinfo->building_name)
                                        Building Name: {{ $r->clientsinfo->building_name ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->road_no)
                                        Road No: {{ $r->clientsinfo->road_no ?? '' }},<br>
                                    @endif
                                    @if ($r->clientsinfo->block_sector)
                                        Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }},
                                    @endif
                                    @if ($r->clientsinfo->area)
                                        Area : {{ $r->clientsinfo->area ?? '' }}, <br>
                                    @endif
                                    @if ($r->clientsinfo->box)
                                        Box : {{ $r->clientsinfo->box ?? '' }}
                                    @endif
                                </p>
                            </td>
                            <td>{{ date('d-M-Y', strtotime($r['expire_date'])) }}</td>
                            <td>
                                @if (isset($all_customer[$r->userid]['last-logged-out']))
                                    {{ $all_customer[$r->userid]['last-logged-out'] }}
                                @endif
                                <br>
                                @if (isset($all_customer[$r->userid]['last-disconnect-reason']))
                                    <span
                                        class="btn btn-danger btn-xs">{{ $all_customer[$r->userid]['last-disconnect-reason'] }}</span>
                                @endif
                            </td>


                        </tr>
                    @endforeach

                </tbody>
            </table>
        @else
            <table id="dataTable" class="table table-bordered">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col">UserName</th>
                        <th>Nas IP</th>
                        <th>Assigned IP</th>
                        <th>Logout Reason</th>
                        <th>Last Update Time</th>
                        <th>Logout Time</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">

                    @foreach ($list as $r)

                        <tr>
                            <td>{{ $r->username }}</td>
                            <td>{{ $r->nasipaddress }}</td>
                            <td>{{ $r->framedipaddress }}</td>
                            <td>{{ $r->acctterminatecause }}</td>
                            <td>{{ $r->acctupdatetime }}</td>
                            <td>{{ $r->acctstoptime }}</td>

                        </tr>
                    @endforeach


                </tbody>
            </table>
        @endif

    </div>
</div>
