 <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>


 <script type="text/javascript">
     google.charts.load("current", {
         packages: ["corechart"]
     });
     google.charts.setOnLoadCallback(drawChart);

     function drawChart() {
         var data = google.visualization.arrayToDataTable([
             ['Task', 'Hours per Day', ],
             ['Total Active Customer',
                 <?php echo e($clientCount->where('clients_status', 'active')->first()->total ?? 0); ?>,
             ],
             ['Total Deactivated Customer',
                 <?php echo e($clientCount->where('clients_status', 'deactive')->first()->total ?? 0); ?>

             ],
             ["Expired Customer", <?php echo e($clientCount->where('clients_status', 'expired')->first()->total ?? 0); ?>],
             ['Pending Customer', <?php echo e($clientCount->where('client_approval', 'pending')->first()->total ?? 0); ?>],
             ["<?php echo e(date('F Y')); ?> New Customer", <?php echo e($newClients ?? 0); ?>],
             ["<?php echo e(date('F Y')); ?> Deactivated Customer", <?php echo e($thisMonthDeactive); ?>],
         ]);

         var options = {
             title: '',
             pieHole: 0.4,
         };

         var chart = new google.visualization.PieChart(document.getElementById('customer_info'));
         chart.draw(data, options);
     }
 </script>
 <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-dashboard')): ?>
     <script type="text/javascript">
         google.charts.load("current", {
             packages: ["corechart"]
         });

         google.charts.setOnLoadCallback(drawStuff);

         function drawStuff() {
             var data = google.visualization.arrayToDataTable([
                 ['Element', 'Tk', {
                     role: 'style'
                 }],
                 ["Amount", <?php echo e((float) $thisMonthBillGenerate); ?>, '#3366CC'],
                 ["Collection", <?php echo e((float) $thisMonthBillPaid); ?>, '#990099'],
                 ["Due", <?php echo e((float) $currentMonthDue); ?>, '#FF9900'],
             ]);

             var options = {
                 width: 300,
                 legend: {
                     position: 'none'
                 },
                 axes: {
                     x: {
                         0: {
                             side: 'top',
                             label: 'Bill Collection of <?php echo e(date('F Y')); ?>'
                         }
                     }
                 },
                 hAxis: {
                     title: 'Only Own Manager',

                 },
                 bar: {
                     groupWidth: "90%"
                 }
             };

             var chart = new google.visualization.ColumnChart(document.getElementById('accounts_info'));
             chart.draw(data, options);
         }

         window.addEventListener('resize', drawStuff); // Optional: make chart responsive
     </script>
 <?php endif; ?>

 <script type="text/javascript">
     google.charts.load("current", {
         packages: ['corechart']
     });
     google.charts.setOnLoadCallback(drawChart);

     function drawChart() {
         var data = google.visualization.arrayToDataTable([
             ['Month', 'Total Active Clients', {
                 role: 'style'
             }],
             <?php
                 $colors = ['#3366cc', '#dc3912', '#ff9900', '#109618', '#990099', '#0099c6', '#dd4477', '#66aa00', '#b82e2e', '#316395', '#994499', '#22aa99'];
                 $index = 0;
             ?>
             <?php $__currentLoopData = $clientSummary->reverse(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $summary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 ['<?php echo e($summary->month_year); ?>', <?php echo e($summary->total_active_clients); ?>,
                     '<?php echo e($colors[$index % count($colors)]); ?>'
                 ],
                 <?php $index++; ?>
             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         ]);

         var view = new google.visualization.DataView(data);
         view.setColumns([0, 1,
             {
                 calc: "stringify",
                 sourceColumn: 1,
                 type: "string",
                 role: "annotation"
             },
             2
         ]);

         var options = {
             title: 'Client Growth (Last 12 Months)',
             width: 500,
            //  height: 500,
             bar: {
                 groupWidth: "80%"
             },
             legend: {
                 position: "none"
             },
             vAxis: {
                 title: 'Total Active Clients',
                 titleTextStyle: {
                     color: '#333',
                     fontSize: 14
                 },
                 textStyle: {
                     color: '#555',
                     fontSize: 12
                 }
             },
             hAxis: {
                 title: 'Month',
                 titleTextStyle: {
                     color: '#333',
                     fontSize: 14
                 },
                 textStyle: {
                     color: '#555',
                     fontSize: 12
                 }
             }
         };

         var chart = new google.visualization.ColumnChart(document.getElementById('client_summery'));
         chart.draw(view, options);
     }
 </script>








 <style>
     #accounts_info {
         display: flex;
         justify-content: center;
         align-items: center;
         height: 400px;
     }

     #customer_info {
         display: flex;
         justify-content: center;
         align-items: center;
         height: 400px;

     }

     #client_summery {
         display: flex;
         justify-content: center;
         align-items: center;
         height: 400px;

     }
 </style>
<?php /**PATH /var/www/html/crp/radius-circle/resources/views/layout/dashboard_chart.blade.php ENDPATH**/ ?>