@extends('layout.app')


@section('content')

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col">
                                ID
                            </th>
                            <th scope="col">
                                Manager
                            </th>
                            <th scope="col">
                                POP
                            </th>
                            <th scope="col">
                                Box
                            </th>
                            <th scope="col">

                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($boxs as $item)
                            <tr>
                                <td>
                                    {{ $item->id }}
                                </td>
                                <td>
                                    {{ $item->manager->name ?? '' }}
                                </td>
                                <td>
                                    {{ $item->pop->popname ?? '' }}
                                </td>
                                <td>
                                    {{ $item->box_name }}
                                </td>
                                <td>
                                    <a href="{{ route('box.edit', $item->id) }}"
                                        class="btn btn-primary pull-right">Edit</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer">
            {{ $boxs->links() }}

        </div>
    </div>







@endsection
