<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class FileExport implements FromCollection, WithHeadings, ShouldAutoSize
{

    protected $data, $array;

    function __construct($data, $array)
    {
        $this->data = $data;
        $this->list = $array;
    }

    public function headings(): array
    {
        $arr =[];
            if($this->list['id'] != null){
                array_push($arr,"User Id");
            }
            if ($this->list['name'] != null) {
                array_push($arr,"Name");
            }
            if ($this->list['password'] != null) {
                array_push($arr,"Password");
            }
            if ($this->list['date'] != null) {
                array_push($arr,"Joining Date / Create Date");
            }
            if ($this->list['speed'] != null) {
                array_push($arr,"Speed / Package");
            }
            if ($this->list['status'] != null) {
                array_push($arr,"Connection Status");
            }
            if ($this->list['remarks'] != null) {
                array_push($arr,"Remarks");
            }

            array_push($arr,"Expire Date");
            
        return $arr;
    }


    public function collection()
    {
        $items = [];
        $i = 0;
        foreach ($this->data as $client) {

            // if ($client->clients_status === 'active') {
            //     $status = "Active";
            // } else {
            //     $status = "Deactive";
            // }

            if ($this->list['id'] != null) {
                $userId = $client->userid;
                $items[$i][] = $userId;
            }
            // dd($items);
            if ($this->list['name'] != null) {
                $name = $client->clientsinfo->clients_name;
                $items[$i][] = $name;
            }
            if ($this->list['password'] != null) {
                $password = $client->password;
                $items[$i][] = $password;
            }
            if ($this->list['date'] != null) {
                $date =  'CD :' . ' ' . date('d-M-Y', strtotime($client->created_at ?? '')) . ' ' . 'JD :' . ' ' . date('d-M-Y', strtotime($client->clientsinfo->joinDate ?? ''));
                $items[$i][] = $date;

            }
            if ($this->list['speed'] != null) {
                if($client->subpack){
                    $speed =  'Sub Pack:' . $client->subpack->name . "\n" .'Main Pack:' . $client->packages->package_name;
                    $items[$i][] = $speed;
                }else{
                    $speed =  'Pack:' . $client->packages->package_name;
                    $items[$i][] = $speed;

                }

            }
            if ($this->list['status'] != null) {
                $connection = $client->clients_status;
                $items[$i][] = $connection;

            }
            if ($this->list['remarks'] != null) {
                $remarks = $client->clientsinfo->remarks;
                $items[$i][] = $remarks;

            }
                
                $items[$i][] = $client->expire_date;

            $i++;
        }

        // dd($items);

        return collect($items);
    }
}
