import React from "react";
import { InfoWindow } from "@react-google-maps/api";
import { Table } from "react-bootstrap";

function ClientDetailTable({ clientInfo }) {
    return (
        <Table striped bordered hover>
            <tbody>
                <tr>
                    <td>ID</td>
                    <td>{clientInfo.client_id}</td>
                </tr>
                <tr>
                    <td>Client Name</td>
                    <td>{clientInfo.clients_name}</td>
                </tr>
                <tr>
                    <td>Client Status</td>
                    <td>{clientInfo.client.clients_status}</td>
                </tr>
                <tr>
                    <td>Box</td>
                    <td>{clientInfo.box}</td>
                </tr>

                <tr>
                    <td>Contact No</td>
                    <td>{clientInfo.contact_no}</td>
                </tr>

                <tr>
                    <td>Flat No</td>
                    <td>{clientInfo.flat_no}</td>
                </tr>
                <tr>
                    <td>Building Name</td>
                    <td>{clientInfo.building_name}</td>
                </tr>
                <tr>
                    <td>Road No</td>
                    <td>{clientInfo.road_no}</td>
                </tr>
                <tr>
                    <td>Area</td>
                    <td>{clientInfo.area}</td>
                </tr>
                <tr>
                    <td>Cable Type</td>
                    <td>{clientInfo.cable_type}</td>
                </tr>
            </tbody>
        </Table>
    );
}

export function ClientDetailInfo({ clientInfo, coordinates, setShowDetail }) {
    return (
        <InfoWindow
            position={coordinates}
            onCloseClick={() => setShowDetail(false)}
        >
            <div>
                <div className="p-1 d-flex align-items-center">
                    <h5 className="m-0">
                        {clientInfo.client.id}: {clientInfo.clients_name} (
                        {clientInfo.client.userid})
                    </h5>
                    <span
                        className="border-1"
                        title={
                            clientInfo.status === true ? "Online" : "Offline"
                        }
                    >
                        <div
                            className={`ms-1 bg-${
                                clientInfo.status ? "success" : "danger"
                            } px-2 py-2 rounded-circle`}
                        />
                    </span>
                </div>
                <hr className="m-0" />
                <ClientDetailTable clientInfo={clientInfo} />
            </div>
        </InfoWindow>
    );
}
