@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">


            <div class="col-md-3 d-flex-justify-content-center">
                {{ $type }} Log History
            </div>

            <table class="table-responsive w-100 table-bordered">
                <thead>
                    <th class="text-center">Date</th>
                    <th class="text-center">Edit By</th>
                    <th class="text-center">Old Data</th>
                    <th class="text-center">New Data</th>
                </thead>
                <tbody>
                    @foreach ($list as $log)
                        @php
                            $old = json_decode($log->old_info);
                            $new = json_decode($log->new_info);

                            $change_old = [];
                            $change_new = [];
                            foreach ($old as $key => $value) {
                                if ($old->$key != $new->$key && $key != 'updated_at') {
                                    $change_old[$key] = $old->$key;
                                    $change_new[$key] = $new->$key;
                                }
                            }
                        @endphp
                        <tr>
                            <td class="p-1">{{ $log->created_at->format('d-m-Y H:i:s') }}</td>
                            <td class="text-center">{{ $log->user->name ?? '' }}</td>

                            @if ($change_old)
                                <td class="text-center w-50">
                                    <table class="table table-bordered table-responsive ">
                                        <thead style="background: #fdba74;color:#FFFFFF;">

                                            @foreach ($change_old as $key => $value)
                                                <th>{{ $key }}</th>
                                            @endforeach

                                        </thead>

                                        <tbody>
                                            @foreach ($change_old as $key => $value)
                                                <th>{{ $value }}</th>
                                            @endforeach
                                        </tbody>

                                    </table>
                                </td>
                            @endif

                            @if ($change_new)
                                <td class="text-center w-50">
                                    <table class="table-responsive table table-bordered ">
                                        <thead style="background:#84cc16 !important;color:#FFFFFF;">

                                            @foreach ($change_new as $key => $value)
                                                <th>{{ $key }}</th>
                                            @endforeach

                                        </thead>

                                        <tbody>
                                            @foreach ($change_new as $key => $value)
                                                <td>{{ $value }}</td>
                                            @endforeach
                                        </tbody>

                                    </table>
                                </td>
                            @endif



                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        #wrap span,
        td a,
        td span {
            white-space: normal !important;
        }
    </style>
@endpush

@section('ajax')
@endsection
