<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\Client;
use App\Models\Packages;
use App\Models\BillGenerate;
use App\Models\BillGeneratesArchive;
use App\Services\ExpireCheck;
use App\Models\CustomerAccount;
use App\Services\PriceCalculate;
use Illuminate\Support\Facades\DB;

class ClientActiveDeactiveService
{


  /**
   * client table deactive
   * radcheck deactive
   *
   */

  public function deactive($request)
  {

    $client = Client::find($request->id);

    DB::beginTransaction();

    try {
      $client->clients_status = 'deactive';
      $client->save();

      DB::table('radcheck')
        ->whereUsername($client->userid)
        ->update([
          'op' => '!='
        ]);

      DB::commit();
    } catch (\Throwable $th) {
      DB::rollback();
      return 'error';
    }
  }




  /**
   * generate bill for current month
   * active clients table row
   * active radcheck table row
   * add amount on customer account balance
   */

  public function reactivate($request)
  {
    $id = $request->id;
    $user = Client::find($id);

    if (config('app.daily_pricing') == false) {

      return $this->dailyPricingFalse($user);
    }

    return $this->dailyPricingTrue($user);
  }




  public function dailyPricingTrue($user)
  {
    $last_bill_date = date('Y-m-' . $user->billing_cycle);
    $expire_date = $user->expire_date;
    $id = $user->id;

    $package = Packages::find($user->package_id);
    $package_price = $package->package_rate;

    if ($last_bill_date < $expire_date) {
      $expire_date = $user->expire_date;
    } else {
      $expire_date = Carbon::parse($last_bill_date)->addMonth(1);
    }

    try {
      return DB::transaction(function () use ($user, $last_bill_date, $expire_date, $id, $package_price) {

        BillGenerate::create([
          'description'  => 'Reactivated Customer Bill Entry',
          'bill_amount'  => $package_price,
          'client_id'    => $id,
          'billing_type' => 'reactive',
          'due_date'     => $expire_date
        ]);

        Client::where('id', $id)->update(['clients_status'  => 'active']);

        DB::table('radcheck')->whereUsername($user->userid)->update(['op' => ':=']);
        CustomerAccount::updateCustomrAccount($id, $user->package_rate, 0, 0, $user->package_rate);

        return 'success';
      });
    } catch (\Throwable $th) {


      return 'error';
    }
  }

  public function dailyPricingFalse($user)
  {



    $last_bill_date = date('Y-m-' . $user->billing_cycle);
    $expire_date = $user->expire_date;
    $id = $user->id;

    $package_price = Packages::find($user->package_id)->package_rate;



    if ($last_bill_date < $expire_date) {
      $expire_date = $user->expire_date;
    } else {
      $expire_date = Carbon::parse($last_bill_date)->addMonth(1);
    }

    try {
      return DB::transaction(function () use ($user, $last_bill_date, $expire_date, $id, $package_price) {

        BillGenerate::create([
          'description'  => 'Reactivated Customer Bill Entry',
          'bill_amount'  => $package_price,
          'client_id'    => $id,
          'billing_type' => 'reactive',
          'due_date'     => $expire_date
        ]);

        Client::where('id', $id)->update(['clients_status'  => 'active']);

        DB::table('radcheck')->whereUsername($user->userid)->update(['op' => ':=']);
        CustomerAccount::updateCustomrAccount($id, $user->package_rate, 0, 0, $user->package_rate);

        return 'success';
      });
    } catch (\Throwable $th) {

      return 'error';
    }
  }
}

