<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\ClientSummary;
use App\Models\Reseller;
use Illuminate\Http\Request;

class CustomerSummaryController extends Controller
{
    public function allCustomerSummary()
    {
        $reseller = Reseller::with('pops.clients')->get();
        $data = [
            'resellers' => $reseller
        ];

        return view('customerSummary.summary', $data);
    }

    public function clientSummaryReport(Request $request)
    {
        if ($request->has('month_year')) {
            $monthYear = ClientSummary::find($request->month_year);
        } else {
            $monthYear = now()->format('M-Y');
        }
        $clientSummery = ClientSummary::where('month_year', $monthYear)->first();

        $currentClients = Client::pluck('clients_status', 'id')->toArray();
        $allMonths = ClientSummary::orderBy('id', 'desc')->whereNotNull('active_ides')->get();

        $data = [
            'activeClients' => json_decode($clientSummery->active_ides),
            'currentClients' => $currentClients,
            'allMonths' => $allMonths,
        ];



        return view('customerSummary.report', $data);
    }
}
