@canany(['user-registration', 'user_index', 'employee_index', 'employee_create', 'role_index', 'role_create',
    'customer-export'])
    <li
        class="nav-item  {{ request()->routeIs(['user*', 'marketing-new-customer-report', 'oltinfo*', 'employees*', 'roles*', 'permissions*', 'global-settings.index', 'company-settings.index', 'payment-method*', 'exportList', 'check-in-redcheck', 'radUserUpdateList', 'accoutningServer*', 'marketing-user*','client-summary-report','qr.generator']) ? 'menu-open' : '' }}">
        <a href="#" class="nav-link">
            <i class="fas fa-user-cog nav-icon"></i>
            <p>
                Admin
                <i class="fas fa-angle-left right"></i>
            </p>
        </a>
        <ul class="nav nav-treeview ml-2">

            @can('employee_create')
                <li class="nav-item"><a href="{{ route('employees.create') }}"
                        class="nav-link {{ request()->routeIs(['employees.create']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add Employee</p>
                    </a>
                </li>
            @endcan

            @can('role_create')
                <li class="nav-item"><a href="{{ route('roles.create') }}"
                        class="nav-link {{ request()->routeIs(['roles.create']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add Role</p>
                    </a></li>
            @endcan

            @can('user-registration')
                <li class="nav-item"><a href="{{ route('user.create') }}"
                        class="nav-link {{ request()->routeIs(['user.create']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add User</p>
                    </a></li>
            @endcan

            @if (checkSettings('deactive_all_expire_customer') == 'enable')
                @can('deactive_all_expire_customer')
                    <li class="nav-item">
                        <a onclick="return confirm('Are you sure?')" href="{{ url('admin/deactive-all-expired-customer') }}"
                            class="nav-link">
                            <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                            <p>Deactive All Expire customer</p>
                        </a>
                    </li>
                @endcan
            @endif



            @can('employee_index')
                <li class="nav-item"><a href="{{ route('employees.index') }}"
                        class="nav-link {{ request()->routeIs(['employees.index']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Employees</p>
                    </a></li>
            @endcan

            @can('customer-export')
                <li class="nav-item"><a href="{{ route('exportList') }}"
                        class="nav-link {{ request()->routeIs(['exportList']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>File Export</p>
                    </a>
                </li>
            @endcan


            <li class="nav-item"><a href="{{ route('location.index') }}"
                    class="nav-link {{ request()->routeIs(['location.index']) ? 'active' : '' }}">
                    <i class="ml-2 far fa-circle nav-icon" style="font-size: 6px !important"></i>
                    <p>Location</p>
                </a>
            </li>
            @can('add-marketer')
                <li class="nav-item"><a href="{{ route('marketing-user.index') }}"
                        class="nav-link {{ request()->routeIs(['marketing-user.index']) ? 'active' : '' }}">
                        <i class="ml-2 far fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Marketing Users</p>
                    </a>
                </li>
            @endcan

            @can('marketing-new-customer-report')
                <li class="nav-item"><a href="{{ route('marketing-new-customer-report') }}"
                        class="nav-link {{ request()->routeIs(['marketing-new-customer-report']) ? 'active' : '' }}">
                        <i class="ml-2 far fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>KAM Report</p>
                    </a>
                </li>
            @endcan

            @can('payment-method')
                <li class="nav-item"><a href="{{ route('payment-method.index') }}"
                        class="nav-link {{ request()->routeIs(['payment-method.index']) ? 'active' : '' }}">
                        <i class="ml-2 far fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Payment Method</p>
                    </a>
                </li>
            @endcan



            @can('role_index')
                <li class="nav-item"><a href="{{ route('roles.index') }}"
                        class="nav-link {{ request()->routeIs(['roles.index']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Roles</p>
                    </a></li>
            @endcan
            {{-- @can('permission_index')
                <li class="nav-item"><a href="{{ route('permissions.index') }}"
                        class="nav-link {{ request()->routeIs(['permissions.index']) ? 'active' : '' }}">
                        <i class="ml-2 far fa-circle nav-icon" style="font-size: 10px"></i>
                        <p>Permissions</p>
                    </a></li>
            @endcan --}}

            @can('company-info')
                <li class="nav-item"><a href="{{ route('company-settings.index') }}"
                        class="nav-link {{ request()->routeIs(['company-settings.index']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p> Settings</p>
                    </a>
                </li>
            @endcan

            @if (auth()->user()->id == 1)
                <li class="nav-item"><a href="{{ route('editLog-history', ['id' => 1, 'type' => 'CompanyInfo']) }}"
                        class="nav-link {{ request()->routeIs(['editLog-history']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Setting History</p>
                    </a>
                </li>
                <li class="nav-item"><a href="{{ route('qr.generator') }}"
                    class="nav-link {{ request()->routeIs(['qr.generator']) ? 'active' : '' }}">
                    <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Generate Any QR Code</p>
                    </a>
                </li>
            @endif

            @can('sms_config')
                <li class="nav-item"><a href="{{ route('sms.index') }}" class="nav-link">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>SMS</p>
                    </a></li>
            @endcan

            @can('user_index')
                <li class="nav-item"><a href="{{ route('user.index') }}"
                        class="nav-link {{ request()->routeIs(['user.index']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Users</p>
                    </a></li>
            @endcan




            @if (auth()->user()->id == 1)
                <li class="nav-item"><a href="{{ route('oltinfo.index') }}"
                        class="nav-link {{ request()->routeIs(['oltinfo.index']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Olt Info</p>
                    </a>
                </li>
            @endif

            @if (auth()->user()->id == 1)
                <li class="nav-item"><a href="{{ route('generateMonthlyBill') }}"
                        class="nav-link {{ request()->routeIs(['generateMonthlyBill']) ? 'active' : '' }}">
                        <i class="ml-2 far fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Generate Monthly Bill</p>
                    </a>
                </li>
                <li class="nav-item"><a href="{{ route('global-settings.index') }}"
                        class="nav-link {{ request()->routeIs(['global-settings.index']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Global Settings</p>
                    </a>
                </li>
                <li class="nav-item"><a href="{{ route('optimizeClear') }}"
                        class="nav-link {{ request()->routeIs(['optimizeClear']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Optimize Clear</p>
                    </a>
                <li class="nav-item"><a href="{{ route('optimize') }}"
                        class="nav-link {{ request()->routeIs(['optimize']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Optimize</p>
                    </a>
                </li>
                <li class="nav-item"><a href="{{ route('payBiilLog.index') }}"
                        class="nav-link {{ request()->routeIs(['payBiilLog.index']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Pay Bill Log</p>
                    </a>
                </li>

                <li class="nav-item"><a href="{{ route('check-in-redcheck') }}"
                        class="nav-link {{ request()->routeIs(['check-in-redcheck']) ? 'active' : '' }}">
                        <i class="ml-2 far fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Radcheck user</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('radUserUpdateList') }}"
                        class="nav-link {{ request()->routeIs(['radUserUpdateList']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Radius User Update</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('delete-client-manager-all-info') }}"
                        class="nav-link {{ request()->routeIs(['delete-client-manager-all-info']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Delete all by Manager Id</p>
                    </a>
                </li>
                <li class="nav-item"><a href="{{ route('accoutningServer.index') }}"
                        class="nav-link {{ request()->routeIs(['accoutningServer']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Accounting Servers</p>
                    </a>
                </li>

                <li class="nav-item"><a href="{{ route('client-summary-report') }}"
                        class="nav-link {{ request()->routeIs(['client-summary-report']) ? 'active' : '' }}">
                        <i class="ml-2 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Client Summary report</p>
                    </a>
                </li>
            @endif

        </ul>
    </li>

@endcan
