<table class="table table-bordered">
    <thead>
        @if (request()->path() == 'admin/clientSearchReport')
            <tr>
                <td colspan="15">
                    <p class="text-center">{{ $status }}</p>
                    <p class="text-center">
                        {!! $packages_count !!}
                    </p>
                </td>
            </tr>
        @endif
        <tr>
            @if (request()->path() == 'admin/clientSearchReport')
                <th class="text-center">
                    @if (in_array('customer-recharge-batch', userPermissions()))
                        <input type="checkbox" id="checkAll">
                    @endif
                </th>
            @endif
            <th class="bg-dark">ID</th>
            <th class="bg-dark">User name</th>
            <th class="bg-dark">Status</th>
            <th class="bg-dark">Expire Date</th>
            <th class="bg-dark">Bill Cycle</th>
            <th class="bg-dark">Package</th>
            <th class="bg-dark">Package price</th>
            <th class="bg-dark">POP</th>
            <th class="bg-dark">Name</th>
            <th class="bg-dark" style="min-width: 200px;">Address</th>
            <th class="bg-dark">Contact No</th>
            <th class="bg-dark">Connection Date</th>
            <th class="bg-dark">Action</th>
        </tr>
    </thead>
    <tbody class="bg-white divide-y divide-gray-200">
        @foreach ($list as $r)
            <tr>
                @if (request()->path() == 'admin/clientSearchReport')
                    <td class="text-center">
                        @if (in_array('customer-recharge', userPermissions()))
                            @if (userPops()->find($r->pop_id)->bill_generate != 'yes')
                                <input type="checkbox" value="{{ $r->id }}" class="checkbox" id="row_id"
                                    name="ids[]">
                                @if (auth()->user()->hasRole(['Reseller Admin', 'Admin', 'Accounts Executive']))
                                    <input type="hidden" name="price[]" class="current_price"
                                        value="{{ $r->packages->package_rate ?? 0 }}">
                                @elseif(auth()->user()->hasRole(['Sub Reseller']))
                                    <input type="hidden" name="price[]" class="current_price"
                                        value="{{ $r->subpack->rate }}">
                                @endif
                            @endif
                        @endif

                    </td>
                @endif
                <td>

                    @if ($r->pop->bill_generate == 'yes')
                        <a target="_blank" class="btn btn-info btn-block btn-xs text-nowrap"
                            href="{{ url('admin/getPaymentHistory', $r->id) }}">CID: {{ $r->id }}</a>
                    @else
                        <span class="btn btn-info btn-block btn-xs text-nowrap">CID:{{ $r->id }}</span>
                    @endif

                    <a target="_blank" href="{{ route('clients.show', $r->id) }}"
                        class="noprint btn btn-primary btn-xs btn-block">Details</a>

                </td>
                <td>
                    {{ $r->userid }}
                    <br>
                    {{ $r->password }}

                </td>

                @if ($r->clients_status == 'expired')
                    <td class="deactive bg-danger">
                        Expired
                    @elseif($r->clients_status == 'deactive')
                    <td class="deactive bg-gray">
                        Deactive
                    @elseif($r->clients_status == 'disable')
                    <td class="bg-warning">
                        Disable
                    @elseif($r->clients_status == 'active')
                    <td class="bg-success">
                        Active
                    @elseif($r->client_approval == 'pending')
                    <td>
                        Pending
                @endif
                </td>

                {{-- @if ($r->clients_status == 'expired')
                  <td class="bg-danger whitespace-nowrap">
                      {{ date('d-M-Y', strtotime($r->expire_date)) }}
                  </td>
              @else
                  <td class="bg-success whitespace-nowrap">
                      {{ date('d-M-Y', strtotime($r->expire_date)) }}
                  </td>
              @endif --}}

                <td
                    class="
              @if ($r->clients_status == 'expired') bg-danger
                  @elseif($r->clients_status == 'deactive')
                  bg-gray
                  @elseif($r->clients_status == 'disable')
                 bg-warning
                  @elseif($r->clients_status == 'active')
                  bg-success @endif
              ">
                    {{ date('d-M-Y', strtotime($r->expire_date)) }}
                </td>

                <td>
                    {{ $r->billing_cycle }}
                </td>

                <td>
                    @if (in_array('show-sub-package', userPermissions()))
                        <span class="badge badge-info d-block">
                            {{ $r->subpack->name ?? '' }}</span>
                    @endif

                    @if (in_array('show-mother-package', userPermissions()))
                        <span class="badge badge-info d-block mt-1">
                            {{ $r->packages->package_name ?? '' }}</span>
                    @endif
                </td>

                <td>
                    @if (in_array('show-sub-package-rate', userPermissions()))
                        <span class="badge badge-info">{{ $r->subpack->rate ?? 0 }}</span>
                    @endif

                    @if (in_array('show-motherpackage-rate', userPermissions()))
                        <span class="badge badge-info">{{ $r->packages->package_rate ?? 0 }}</span>
                    @endif

                    <span>
                        @if ($r->pop->bill_generate == 'yes')
                            <p class="text-danger">Due: {{ $r->dueAmount }}</p>
                        @endif
                    </span>
                </td>
                <td>

                    {{ userPops()->find($r->pop_id)->popname ?? '' }}

                </td>

                <td>
                    {{ $r->clientsinfo->clients_name ?? '' }}
                </td>

                <td style="max-width:250px;">
                    <p style="font-size:12px;">
                        @if (!empty($r->clientsinfo->flat_no))
                            <b>Flat No :</b> {{ $r->clientsinfo->flat_no ?? '' }} ,
                        @endif
                        @if (!empty($r->clientsinfo->building_name))
                            <b>Building Name :</b> {{ $r->clientsinfo->building_name ?? '' }} ,
                        @endif
                        @if (!empty($r->clientsinfo->road_no))
                            <b>Road No :</b> {{ $r->clientsinfo->road_no ?? '' }} ,
                        @endif
                        @if (!empty($r->clientsinfo->block_sector))
                            <b>Block/Sector :</b> {{ $r->clientsinfo->block_sector ?? '' }} ,
                        @endif
                        @if (!empty($r->clientsinfo->area))
                            <b>Area :</b> {{ $r->clientsinfo->area ?? '' }},
                        @endif
                        @if (!empty($r->clientsinfo->box))
                            <b>Box :</b> {{ $r->clientsinfo->box ?? '' }} ,
                        @endif
                        <br>
                        @if (!empty($r->clientsinfo->client_latitude))
                            <b>Latitude :</b> {{ $r->clientsinfo->client_latitude ?? '' }} ,
                        @endif
                        <br>
                        @if (!empty($r->clientsinfo->client_longitude))
                            <b>Longitude :</b> {{ $r->clientsinfo->client_longitude ?? '' }}
                    </p>
        @endif
        </td>
        <td>{{ $r->clientsinfo->contact_no ?? '' }}</td>
        <td class="whitespace-nowrap">
            <strong>CD:</strong> {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}<br>
            @if ($r->clientsinfo->joinDate)
                <strong>JD:</strong> {{ date('d-M-Y', strtotime($r->clientsinfo->joinDate)) }}
            @endif
        </td>

        <td class="text-center noprint" style="width:160px;">








            @if (in_array('mac-customer_edit', userPermissions()))
                <a href="{{ route('clients.edit', $r->id) }}"
                    class="btn btn-primary btn-block inline-block btn-xs">Edit</a>
            @endif

            @if ($r->clients_status != 'deactive')
            @elseif($r->clients_status == 'deactive')
                {{-- @can('customer-reactivate') --}}
                @if (in_array('customer-reactivate', userPermissions()))
                    <button onclick="status({{ $r->id }},'idEnable')" type="button"
                        class="btn btn-success btn-block btn-xs">Reactive</button>
                @endif
            @endif

            <div class="mb-1"></div>
            @if (in_array('customer-recharge', userPermissions()))
                @if ($r->clients_status != 'deactive')
                    @if ($r->clients_status == 'disable')
                        @if (in_array('id-enable', userPermissions()))
                            <button onclick="status({{ $r->id }},'idEnable')" type="button"
                                class="btn btn-success btn-block btn-xs">Enable</button>
                        @endif
                    @elseif($r->clients_status != 'disable')
                        @if (in_array('id-disable', userPermissions()))
                            <button onclick="status({{ $r->id }},'idDIsable')" type="button"
                                class="btn btn-warning btn-block btn-xs">Disable</button>
                        @endif
                    @endif
                    @if (in_array('customer-deactivated', userPermissions()))
                        <button onclick="status({{ $r->id }},'idDeactive')" type="button"
                            class="btn btn-danger btn-block btn-xs">Deactive</button>
                    @endif
                @endif
            @endif
        </td>

        </tr>
        @endforeach
    </tbody>
</table>
