<div class="col-sm-12">
  <div class="card p-2">
      <div class="table-responsive">
          <table class="table table-bordered">
              <thead class="bg-gray-50">
                  <tr>
                      <p>Report of Monthly Generated Bill Collection {{ date('F Y') }}</p>
                      <th scope="col">
                          Manager
                      </th>
                      <th scope="col">
                          Billed Clients
                      </th>
                      <th scope="col">
                          Bill Amount
                      </th>
                      <th scope="col">
                          Received ID
                      </th>

                      <th scope="col">
                          Received Amount
                      </th>
                      <th scope="col">
                          Col. %
                      </th>
                      <th scope="col">
                          Due Clients
                      </th>

                      <th scope="col">
                          Due Amount
                      </th>





                  </tr>
              </thead>
              <tbody class="bg-white divide-y divide-gray-200">
                  @php
                      $dueClients = 0;
                      $dueAmounts = 0;
                      $clientscount = 0;
                      $totalAmounts = 0;
                  @endphp
                  @foreach ($monthlyCount as $item)
                      <tr>
                          <td class="whitespace-nowrap">
                              {{ $item->name }}
                          </td>

                          {{-- billed clients --}}
                          <td class="whitespace-nowrap">
                              @php
                                  $sum = 0;
                                  $sum2 = 0;
                                  
                                  foreach ($item->pops as $pop) {
                                      foreach ($pop->clients as $client) {
                                          $sum += $client->generatedBillNow->count();
                                          foreach ($client->generatedBillNow as $billgenerate) {
                                              $sum2 += $billgenerate->bill_amount;
                                          }
                                      }
                                  }
                                  
                              @endphp

                              {{ $sum }}
                          </td>
                          {{-- bill amount --}}
                          <td class="whitespace-nowrap">

                              {{ $sum2 }}
                          </td>
                          {{-- received id --}}
                          <td class="whitespace-nowrap">
                              {{ $temp[$item->id]['tcount'] }}
                          </td>

                          {{-- received amount --}}
                          <td class="whitespace-nowrap">
                              @if ($temp[$item->id]['total'] != null)
                                  {{ $temp[$item->id]['total'] }}
                              @else
                                  0
                              @endif
                          </td>
                          {{-- col % --}}
                          <td class="whitespace-nowrap">
                              @if ($sum2 != 0)
                                  {{ number_format(($temp[$item->id]['total'] * 100) / $sum2, 2) }} %
                              @else
                                  0 %
                              @endif
                          </td>
                          {{-- due clients --}}
                          <td class="whitespace-nowrap">
                              {{ $sum - $temp[$item->id]['tcount'] }}
                          </td>
                          {{-- due amount --}}
                          <td class="whitespace-nowrap">
                              {{ $sum2 - $temp[$item->id]['total'] }}
                          </td>


                          @php
                              $due = $sum - $temp[$item->id]['tcount'];
                              $dueClients += $due;
                              $amounts = $sum2 - $temp[$item->id]['total'];
                              $dueAmounts += $amounts;
                              $clientscount += $sum;
                              $totalAmounts += $sum2;
                              
                          @endphp


                      </tr>
                  @endforeach

                  @php
                      
                      $tcountSum = 0;
                      $totalSum = 0;
                      
                      foreach ($temp as $key => $value) {
                          $tcountSum += $value['tcount'];
                          $totalSum += $value['total'];
                      }
                      
                  @endphp

                  <tr>
                      <td class="whitespace-nowrap">Total</td>
                      <td class="whitespace-nowrap">{{ $clientscount }}</td>
                      <td class="whitespace-nowrap">{{ $totalAmounts }}</td>
                      <td class="whitespace-nowrap">{{ $tcountSum }}</td>
                      <td class="whitespace-nowrap">{{ $totalSum }}</td>
                      <td class="whitespace-nowrap">

                          @if ($totalAmounts != 0)
                              {{ number_format(($totalSum * 100) / $totalAmounts, 2) }} %
                          @else
                              0%
                          @endif

                      </td>
                      <td class="whitespace-nowrap">{{ $dueClients }}</td>
                      <td class="whitespace-nowrap">{{ $dueAmounts }}</td>

                  </tr>


                  <!-- More items... -->
              </tbody>
          </table>
      </div>
  </div>
</div>

<div class="col-sm-12">
  <div class="card p-2">
      <div class="table-responsive">
          <table class="table table-bordered">
              <thead class="bg-gray-50">
                  <tr>
                      <p>Report of New Customer, Package & Billing Cycle Change Bill Collection
                          {{ date('F Y') }}</p>
                      <th scope="col">
                          Area
                      </th>
                      <th scope="col">
                          Bill Amount
                      </th>
                      <th scope="col">
                          Received Amount
                      </th>
                      <th scope="col">
                          Col. %
                      </th>

                      <th scope="col">
                          Due Amount
                      </th>
                  </tr>
              </thead>
              <tbody class="bg-white divide-y divide-gray-200">
                  @php
                    
                      $otherDueAmounts = 0;
                      $clientscount = 0;
                      $otherTotalAmounts = 0;
                  @endphp
                  @foreach ($monthlyOthersCollection as $item)
                      <tr>
                          <td class="whitespace-nowrap">
                              {{ $item->name }}
                          </td>

                          <td class="whitespace-nowrap">
                              @php
                                  
                                  $sum = 0;
                                  
                                  foreach ($item->pops as $pop) {
                                      foreach ($pop->clients as $client) {
                                          foreach ($client->generatedBillOther as $billgenerate) {
                                              $sum += $billgenerate->bill_amount;
                                          }
                                      }
                                  }
                              @endphp

                              {{ $sum }}
                          </td>
                          <td class="whitespace-nowrap">
                              @if ($array[$item->id]['total'] != null)
                                  {{ $array[$item->id]['total'] }}
                              @else
                                  0
                              @endif

                          </td>
                          <td class="whitespace-nowrap">
                              @if ($sum != 0)
                                  {{ number_format(($array[$item->id]['total'] * 100) / $sum, 2) }} %
                              @else
                                  0 %
                              @endif
                          </td>
                          <td class="whitespace-nowrap">
                              {{ $sum - $array[$item->id]['total'] }}
                          </td>



                          @php

                              $amounts = $sum - $array[$item->id]['total'];
                              $otherDueAmounts += $amounts;
                              $otherTotalAmounts += $sum;
                              
                          @endphp
                      </tr>
                  @endforeach
                  <tr>

                      @php
                          
                      
                          $otherTotalSum = 0;
                          
                          foreach ($array as $key => $value) {
                            
                              $otherTotalSum += $value['total'];
                          }
                          
                      @endphp
                      <td class="whitespace-nowrap">Total</td>
                      <td class="whitespace-nowrap">{{$otherTotalAmounts}}</td>
                      <td class="whitespace-nowrap">{{$otherTotalSum}}</td>
                      <td class="whitespace-nowrap">
                          @if ($otherTotalAmounts != 0)
                          {{ number_format(($otherTotalSum * 100) / $otherTotalAmounts, 2) }} %
                      @else
                          0%
                      @endif

                      </td>
                      <td class="whitespace-nowrap">{{$otherDueAmounts}}</td>

                  </tr>


                  <!-- More items... -->
              </tbody>
          </table>
      </div>
  </div>
</div>