@extends('layout.app')

@push('styles')
@endpush

@section('content')
    <div class="card card-body">
        <div class="container">
            <h2>Edit District</h2>
            <form action="{{ route('location.update', $district->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="form-group">
                    <label for="division_id">Division</label>
                    <select name="division_id" id="division_id" class="form-control select2">
                        <option value="">Select Division</option>
                        @foreach ($divisions as $item)
                            <option value="{{ $item->id }}" {{ $district->division_id == $item->id ? 'selected' : '' }}>
                                {{ $item->name }} -- {{ $item->bn_name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="name">District Name(English)</label>
                    <input type="text" name="name" class="form-control" value="{{ $district->name }}"
                        placeholder="district name">
                </div>

                <div class="form-group">
                    <label for="bn_name">District Name(Bengali)</label>
                    <input type="text" name="bn_name" class="form-control" value="{{ $district->bn_name }}"
                        placeholder="district name bengali">
                </div>

                <button type="submit" class="btn btn-primary">Update Location</button>
            </form>
        </div>
    </div>
@endsection


@section('ajax')
    <script></script>
@endsection
