<?php
namespace App\Services;

use Carbon\Carbon;
use App\Models\Pop;
use App\Models\Balance;
use App\Models\Packages;
use App\Models\SubPackage;
use App\Services\PriceCalculate;
use Illuminate\Support\Facades\DB;

class AuthCheckService
{

static public function popList()
{
  $uid = auth()->id();
  
  if(auth()->user()->hasRole('Reseller Admin')){

      $reseller_ids = DB::table('reseller_user')->where('user_id',$uid)->pluck('reseller_id')->toArray();
      $pop_ids = Pop::with('reseller','nas')->where('reseller_id',$reseller_ids)->pluck('id')->toArray();
      

  }elseif(auth()->user()->hasRole('Sub Reseller')){
    
    $pop_ids = DB::table('pop_user')->where('user_id',$uid)->pluck('pop_id')->toArray();        
    
  }elseif(!auth()->user()->hasRole('Admin')){
    $pop_ids = '';
  }

  return $pop_ids;
}

}
