<?php

namespace App\Http\Controllers\OnlinePayment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class UpayController extends Controller
{

    private $base_url;
    private $merchant_id;
    private $merchant_key;
    private $merchant_code;
    private $error;
    private $redirect_url;
    private $merchant_city;
    private $merchant_name;
    private $merchant_category_code;
    private $merchant_mobile;



    public function __construct()
    {
        $this->merchant_id           = config('payment.UPAY_MERCHANT_ID');
        $this->merchant_key          = config('payment.UPAY_MERCHANT_KEY');
        $this->merchant_code         = config('payment.UPAY_MERCHANT_CODE');
        $this->merchant_name         = config('payment.UPAY_MERCHANT_NAME');
        $this->merchant_city         = 'Dhaka';
        $this->merchant_category_code = 'Merchant';
        $this->merchant_mobile       = config('payment.UPAY_WALLET');
        $this->base_url              = config('payment.UPAY_BASE_URL');
        $this->redirect_url          = url('/') . '/admin/upayResellerCallback';
    }




    public function generateToken()
    {

        $post_token = array(
            'merchant_id'   => $this->merchant_id,
            'merchant_key'  => $this->merchant_key
        );

        $url = curl_init($this->base_url . "payment/merchant-auth/");
        $post_token = json_encode($post_token);

        $header = array(
            "Accept: application/json",
            'Content-Type:application/json'
        );

        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_ENCODING, "");
        curl_setopt($url, CURLOPT_MAXREDIRS, 10);
        curl_setopt($url, CURLOPT_TIMEOUT, 30);
        curl_setopt($url, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($url, CURLOPT_POSTFIELDS, $post_token);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        $resultdata = curl_exec($url);
        curl_close($url);

        $response = json_decode($resultdata, true);

        return $response;
    }



    public function createPayment(Request $request)
    {
        $res = $this->generateToken();
        if ($res['code'] == 'DVE4001') {
            return response()->json([
                'status' => 'error',
                'message' => $res['message']
            ]);
        }

        $token = $res['data']['token'];

        if ($token == null) {
            return response()->json([
                'status' => 'error',
                'message' => 'Token Error'
            ]);
        }


        $re['date'] = date('Y-m-d');
        $re['txn_id'] = 'UP_' . now()->timestamp . $request->reseller_id;
        $re['invoice_id'] = now()->timestamp . $request->reseller_id;
        $re['amount'] = $request->amount;
        $re['merchant_id'] = $this->merchant_id;
        $re['merchant_name'] = $this->merchant_name;
        $re['merchant_code'] = $this->merchant_code;
        $re['merchant_country_code'] = 'BD';
        $re['merchant_city'] = $this->merchant_city;
        $re['merchant_category_code'] = $this->merchant_category_code;
        $re['merchant_mobile'] = $this->merchant_mobile;
        $re['transaction_currency_code'] = 'BDT';
        $re['redirect_url'] = $this->redirect_url . "?transaction_id=" . $re['txn_id'] . "&reseller_id=" . $request->reseller_id;


        $url = curl_init($this->base_url . "payment/merchant-payment-init/");
        $request_data_json = json_encode($re);

        $header = array(
            "Authorization: UPAY $token",
            'Content-Type: application/json'
        );

        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_POSTFIELDS, $request_data_json);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $resultdata = curl_exec($url);
        curl_close($url);

        return json_decode($resultdata, true);
    }

    public function validation($request)
    {
        $res = $this->generateToken();
        $token = $res['data']['token'];

        if ($token == null) {
            return response()->json([
                'status' => 'error',
                'message' => 'Token Error'
            ]);
        }

        $url = curl_init($this->base_url . "payment/single-payment-status/$request->transaction_id");

        // dd($url);

        $re['txn_id'] = $request->transaction_id;
        $request_data_json = json_encode($re);

        $header = array(
            "Authorization: UPAY $token",
            'Content-Type: application/json'
        );

        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_POSTFIELDS, $request_data_json);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $resultdata = curl_exec($url);
        curl_close($url);


        // dd($resultdata);

        return json_decode($resultdata, true);
    }
}
