<div class="modal fade " id="form" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered " role="document">
        <div class="modal-content p-3">
            <div class="modal-header border-bottom-0">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="text-danger">&times;</span>

                </button>

            </div>
            <form action="{{ route('mikrotiks.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="d-flex justify-content-between mobile-column" style="gap:2px;">
                        <div class="form-group" style="width: 48%;">
                            <label for="mikrotik name">Mikrotik Name <span class="text-danger"
                                    style="font-size: 1.25rem; display:inline-block;">*</span> </label>
                            <input type="text" name="shortname" class="form-control" id="shortname"
                                value="{{ old('shortname') }}" placeholder="Mikrotik Name">

                            @error('shortname')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-group" style="width: 48%;">
                            <label for="mikrotikip">Mikrotik IP <span class="text-danger"
                                    style="font-size: 1.25rem; display:inline-block;">*</span> </label>
                            <input type="text" name="nasname" class="form-control" placeholder="Mikrotik IP"
                                value="{{ old('nasname') }}" autocomplete="off">
                            @error('nasname')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>

                    @if (!checkAPI())
                        <div class="form-group">
                            <label for="secret" class="">
                                Secret*
                            </label>
                            <input type="text" name="secret" id="secret" class="form-control"
                                placeholder="Mikrotik Radius Secret" value="{{ old('secret') }}" autocomplete="off"
                                required>
                            @error('secret')
                                <small class="form-text text-danger">
                                    {{ $message }}
                                </small>
                            @enderror
                        </div>
                    @endif

                    <div class="form-group">
                        <label for="username">Mikrotik User Name</label>
                        <input type="text" name="mickrotik_user_name" class="form-control" id="email1"
                            placeholder="Mikrotik Username" autocomplete="off">
                        @error('mickrotik_user_name')
                            <small class="form-text  text-danger">{{ $message }}</small>
                        @enderror
                    </div>


                    <div class="d-flex justify-content-between flex-row-reverse mobile-column">
                        <div class="form-group " style="width: 48%;">
                            <label for="mikrotik port">Mikrotik API Port</label>
                            <input type="text" name="mickrotik_port"
                                class="form-control border rounded border-primary" placeholder="Mikrotik Port">
                            @error('mickrotik_port')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-group " style="width: 48%;">
                            <label for="password">Password</label>
                            <input type="password" name="mickrotik_user_password" class="form-control" id="password1"
                                placeholder="Password" autocomplete="off">
                            @error('mickrotik_user_password')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password1">Description <span class="text-danger"
                                style="font-size: 1.25rem; display:inline-block;">*</span> </label>
                        <textarea class="form-control" name="description" id="" cols="3" rows="2">{{ old('description') }}</textarea>
                        @error('description')
                            <small class="form-text  text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    @if (checkSettings('static_ip_manage') == 'enable')
                        <div class="form-group">


                            <button type="button" class=" btn btn-color" id="static_ip_button">Add Static Ip
                            </button>


                            <div class="w-100 p-2 border rounded mt-2 d-none" id="staticIpContainer"
                                style="height: 160px; overflow-y: auto;">
                                <ul class="list-group" id="staticIpList">

                                </ul>
                            </div>

                        </div>
                    @endif
                </div>
                <div class="modal-footer border-top-0 d-flex justify-content-center">
                    <button type="submit" class="btn btn-submit w-100">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    const staticIpCreator = document.getElementById("static_ip_button");
    const staticIpContainer = document.getElementById("staticIpContainer");
    const staticIpList = document.getElementById("staticIpList");

    staticIpCreator.addEventListener("click", function() {
        if (staticIpContainer.classList.contains('d-none')) {
            staticIpContainer.classList.remove('d-none');
            staticIpContainer.classList.add("d-block");
            staticIpCreator.textContent = "Add More";
        }

        const newListItem = document.createElement('li');
        newListItem.className = "list-group-item d-flex justify-content-between";
        newListItem.style.gap = "2px";

        newListItem.innerHTML = `
            <input type="text" name="port[]" class="form-control" placeholder="port" required>
            <input type="text" name="ip_block[]" class="form-control" placeholder="Ip Block" required>
            <button class="text-danger p-1 border rounded delete-button">X</button>`;

        const deleteButton = newListItem.querySelector('.delete-button');

        deleteButton.addEventListener('click', function() {
            staticIpList.removeChild(newListItem);
            if (staticIpList.children.length <= 3) {
                staticIpList.classList.remove("scrollable-list");
            }
            if (staticIpList.children.length === 0) {
                staticIpContainer.classList.remove("d-block");
                staticIpContainer.classList.add('d-none');
                staticIpCreator.textContent = "Add Static Ip";
            }
        });
        staticIpList.appendChild(newListItem);

    });
</script>


<style>
    .container {
        padding: 2rem 0rem;
    }

    ` h4 {
        margin: 2rem 0rem;
    }

    .panel {
        border-radius: 4px;
        padding: 1rem;
        margin-top: 0.2rem;
        background-color: #f5f5f5;
        color: #323b40;
    }

    .panel.panel-blue {
        background-color: #e0f5ff;
        color: #00a5fa;
    }

    .panel.panel-big-height {
        min-height: 150px;
    }

    .item {
        border-radius: 4px;
        padding: 0.5rem;
        margin: 0.2rem;
    }

    .item.item-blue {
        background-color: #b9e5fe;
        color: #00a5fa;
    }

    .item.item-green {
        background-color: #b7e0dc;
        color: #019888;
    }

    .item.item-lime {
        background-color: #c7e8c8;
        color: #42b045;
    }

    .item.item-yellow {
        background-color: #ffeeba;
        color: #ff9901;
    }

    .item.item-pink {
        background-color: #fabad0;
        color: #ef075f;
    }

    .item.item-red {
        background-color: #fec9c6;
        color: #fd3d08;
    }

    .item.item-big-width {
        min-width: 380px;
    }


    label {
        letter-spacing: 0.025em !important;
        font-weight: 600 !important;

    }

    .btn-color {
        background: #374151 !important;
        letter-spacing: 0.025em !important;
        font-weight: 600 !important;
        color: #FFFFFF !important;
    }

    .btn-color:hover {
        background: #262626 !important;

    }

    .btn-submit {
        background: #075985 !important;
        letter-spacing: 0.025em !important;
        font-weight: 600 !important;
        color: #FFFFFF !important;
    }

    .btn-submit:hover {
        background: #155e75 !important;

    }


    /* scroller */

    #staticIpContainer::-webkit-scrollbar {
        width: 6px;

    }


    #staticIpContainer::-webkit-scrollbar-track {
        background: #f1f1f1;

    }

    #staticIpContainer::-webkit-scrollbar-thumb {
        background: #888;

        border-radius: 2.5px;

    }

    #staticIpContainer::-webkit-scrollbar-thumb:hover {
        background: #555;

    }

    #staticIpContainer::-webkit-scrollbar {
        width: 6px;

    }

    /* responsivness */
    @media(min-width:1120px) {
        .modal-dialog {
            max-width: 40% !important;
        }
    }

    @media(max-width:768px) {
        .mobile-column {
            flex-direction: column;
        }

        .form-group {
            width: 100% !important;
        }
    }
</style>
