<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\EmailSetting;
use Illuminate\Http\Request;
use App\Http\Requests\UpdateEmailSettingRequest;
use App\Jobs\SendMailForMonthlyBillJob;
use App\Jobs\SendMailFromFilterJob;
use App\Models\Packages;
use Facade\Ignition\Support\Packagist\Package;

class EmailSettingController extends Controller
{

    public function index()
    {
        $data = ['settings' => EmailSetting::all()];

        return view('emailSetting.index', $data);
    }

    public function store(Request $request)
    {
        $emaill_tamplate = EmailSetting::where('tamplate_name', $request->email_type)->first();
        $emaill_tamplate->email_body = $request->email_body;
        $emaill_tamplate->save();

        exec('/usr/bin/sudo supervisorctl restart all');



        cache()->forget('emailSetting');

        return 1;
    }

    function emailReminder()
    {
        $data = [
            'title' => 'Email Reminder',
            'packages' => Packages::get(),
        ];

        return view('emailSetting.reminder', $data);
    }

    function billReminder()
    {
        SendMailForMonthlyBillJob::dispatch();

        return response()->json([
            'message' => 'Bill sending process is started. For details Please check the Mail log. ',
            'status' => 'success'
        ]);
    }

    function billReminderGroup(Request $request)
    {

        if ($request->reseller_id == null || $request->pop_id == null || $request->package == null) {
            return response()->json([
                'message' => 'Please select all the fields',
                'status' => 'error'
            ]);
        } else {

            $clients = Client::where('pop_id', $request->pop_id)
                ->where('pop_id', $request->pop_id)
                ->whereIn('clients_status', $request->status)
                ->whereIn('package_id', $request->package)
                ->pluck('id');


            SendMailFromFilterJob::dispatch($clients);

            return response()->json([
                'message' => 'Bill sending process is started. For details Please check the Mail log. ',
                'status' => 'success'
            ]);
        }
    }
}
