<?php

namespace Database\Seeders;

use App\Models\EmailSetting;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EmailSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $customer_payment_eamil["sendemail"]="No";
        $customer_payment_eamil["email_body"]="প্রিয় গ্রাহক ({c_name}),\nআপনার বিল সঠিক ভাবে সংগৃহিত হয়েছে। সংগৃহিত টাকার পরিমান- TK {PaymentAmount} | যেকোনো তথ্যের জন্য যোগাযোগ {company_cell} | {company_name} এর সাথে থাকার জন্য ধন্যবাদ।";
        $customer_payment_eamil_jason=json_encode($customer_payment_eamil);

        $bill_generate_email["sendemail"] ="No";
        $bill_generate_email["email_body"] ="Dear {c_name}\n {MonthBillAmount} TK Bill generate for {bill_type}\n\nPlease Pay Before: 05 {ThisMonth}\n\n{company_name}\n{company_cell}";
        $bill_generate_email_json=json_encode($bill_generate_email);

        $data = [
            [
                'tamplate_name' => 'customer_payment_eamil',
                'email_body' => $customer_payment_eamil_jason,
            ], [
                'tamplate_name' => 'bill_generate_eamil',
                'email_body' => $bill_generate_email_json,
            ],
        ];

        foreach($data as $item){
            if(EmailSetting::where('tamplate_name',$item["tamplate_name"])->first() == null){
                DB::table('email_settings')->insert([
                    'tamplate_name' => $item["tamplate_name"],
                    'email_body' => $item["email_body"],

                ]);
            }
        }
    }
}
