import React, { useState } from "react";
import { useSelector } from "react-redux";
import clientIcon from "../../../../assets/icons/client.png";
import { createCoordinateObject } from "../../../../util/validate";
import { Marker, OverlayView } from "@react-google-maps/api";
import { ClientDetailInfo } from "../Clusters/ClusterView/ShowClientsOnMap/ClientDetailInfo";
import axiosInstance from "../../../../util/axiosInstance";

export const ShowNonBoxClient = ({ clientInfo }) => {
    const [showDetail, setShowDetail] = useState(false);
    const [clientDetail, setClientDetail] = useState({});
    const { client_latitude, client_longitude } = clientInfo;

    const coordinates = createCoordinateObject(
        client_latitude,
        client_longitude
    );
    if (!coordinates) return null;

    const showDetailHandler = async () => {
        const data = await axiosInstance.get(
            `clients/getClientDetail/${clientInfo.client.id}`
        );
        setClientDetail(data.data);
        setShowDetail(true);
    };
    return (
        <>
            <Marker position={coordinates} icon={clientIcon} />
            {!showDetail && (
                <OverlayView
                    position={coordinates}
                    mapPaneName={OverlayView.OVERLAY_MOUSE_TARGET}
                    getPixelPositionOffset={() => ({
                        x: -23,
                        y: -73,
                    })}
                >
                    <div
                        className="p-2 text-white bg-dark rounded d-flex align-items-center"
                        onContextMenu={showDetailHandler}
                        style={{ position: "absolute", whiteSpace: "nowrap" }}
                    >
                        <p className="m-0">{clientInfo.client.userid}</p>
                        <span
                            className="border-1"
                            title={
                                clientInfo.status === true
                                    ? "Online"
                                    : "Offline"
                            }
                        >
                            <div
                                className={`ms-1 bg-${
                                    clientInfo.status ? "success" : "danger"
                                } px-2 py-2 rounded-circle`}
                            />
                        </span>
                    </div>
                </OverlayView>
            )}

            {showDetail && (
                <ClientDetailInfo
                    setShowDetail={setShowDetail}
                    coordinates={coordinates}
                    clientInfo={clientDetail}
                />
            )}
        </>
    );
};

const ShowNonBoxClients = () => {
    const { boxClients } = useSelector(
        ({ boxClientReducer }) => boxClientReducer
    );

    return (
        <>
            {boxClients["clientsWithoutBox"]?.map((client) => (
                <ShowNonBoxClient key={client.client.id} clientInfo={client} />
            ))}
        </>
    );
};

export default ShowNonBoxClients;
