@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Provider Add</h3>
            <div class="card-tools">
                <a href="{{ route('band-provider.index') }}"><button class="btn btn-sm btn-primary">Back</button></a>
            </div>
        </div>

        <form action="{{ route('band-provider.store') }}" method="POST" enctype="multipart/form-data">
            @csrf


            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="company_name" class="block text-sm font-medium text-gray-700">
                            Company Name <span style="color: red">(require)</span>
                        </label>
                        <input type="text" name="company_name" id="company_name" value="{{old('company_name')}}" class="form-control"
                            placeholder="Company Name" autocomplete="off" required>
                        @error('company_name')
                            <div class="text-danger mt-2 text-sm ">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="contact_person" class="block text-sm font-medium text-gray-700">
                            Contact Person <span style="color: red">(require)</span>
                        </label>
                        <input type="text" name="contact_person" id="contact_person" class="form-control"
                            placeholder="Contact Person" value="{{old('contact_person')}}" autocomplete="off" required>
                        @error('contact_person')
                            <div class="text-danger mt-2 text-sm ">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="email" class="block text-sm font-medium text-gray-700">
                            Email <span style="color: red">(require)</span>
                        </label>
                        <input type="email" name="email" id="email" class="form-control" placeholder="Email"
                            value="{{old('email')}}" autocomplete="off" required="">
                        @error('email')
                            <div class="text-danger mt-2 text-sm ">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="phone_no" class="block text-sm font-medium text-gray-700">
                            Phone No <span style="color: red">(require and 11 digits)</span>
                        </label>
                        <input type="text" name="phone_no" id="phone_no" class="form-control"
                            placeholder="Phone No must be 11 digits" value="{{old('phone_no')}}" autocomplete="off" required="">
                        @error('phone_no')
                            <div class="text-danger mt-2 text-sm ">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="document" class="block text-sm font-medium text-gray-700">
                            Document <span style="color: green">(optional)</span>
                        </label>
                        <input type="file" name="document" id="document" class="form-control" value="">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="address" class="block text-sm font-medium text-gray-700">
                            Address <span style="color: green">(optional)</span>
                        </label>
                        <textarea name="address" id="address" class="form-control">{{old('address')}}</textarea>
                    </div>

                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Save
                    </button>
                </div>
            </div>
        </form>
    </div>
@endsection
