<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\CustomerAccount;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\BillGenerateController;
use Session;


class CustomerAccountService
{

  public function customer_account_update($user, $bill_amount, $note, $bill_type, $payment_amount = 0, $incomeHeadId = '')
  {

    $bill_amount = round($bill_amount);
    CustomerAccount::updateCustomrAccount($user->id, $bill_amount, 0, 0, $bill_amount);


    if ($bill_amount > 0) {
      $billgenerate =  BillGenerateController::entryBillGenerate($user->id, $bill_amount, $note, $bill_type, $user->expire_date);
      $name = "package_bill_auth" . auth()->user()->id;
      Session::put($name, $billgenerate->id);
      return $billgenerate;
    }

    if (checkSettings('package-bllingcycle-change-auto-payment') == "enable" && $bill_amount > 0 && $payment_amount > 0) {
      (new PaymentController)->autoPayment($user->id, round($payment_amount), $note, $incomeHeadId);
    }
  }
}
